/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefusex.layout;

import edu.berkeley.guir.prefuse.EdgeItem;
import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.NodeItem;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.action.assignment.Layout;
import edu.berkeley.guir.prefuse.graph.Graph;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.Random;

public class FruchtermanReingoldLayout
extends Layout {
    private double forceConstant;
    private double temp;
    private int maxIter = 700;
    private static final double EPSILON = 1.0E-6;
    private static final double ALPHA = 0.1;

    public FruchtermanReingoldLayout() {
        this(700);
    }

    public FruchtermanReingoldLayout(int n) {
        this.maxIter = n;
    }

    public int getMaxIterations() {
        return this.maxIter;
    }

    public void setMaxIterations(int n) {
        this.maxIter = n;
    }

    public void run(ItemRegistry itemRegistry, double d) {
        Graph graph = itemRegistry.getFilteredGraph();
        Rectangle2D rectangle2D = super.getLayoutBounds(itemRegistry);
        this.init(graph, rectangle2D);
        for (int i = 0; i < this.maxIter; ++i) {
            VisualItem visualItem;
            Iterator iterator = graph.getNodes();
            while (iterator.hasNext()) {
                visualItem = (NodeItem)iterator.next();
                if (visualItem.isFixed()) continue;
                this.calcRepulsion(graph, (NodeItem)visualItem);
            }
            iterator = graph.getEdges();
            while (iterator.hasNext()) {
                visualItem = (EdgeItem)iterator.next();
                this.calcAttraction((EdgeItem)visualItem);
            }
            double d2 = 0.0;
            Iterator iterator2 = graph.getNodes();
            while (iterator2.hasNext()) {
                NodeItem nodeItem = (NodeItem)iterator2.next();
                if (nodeItem.isFixed()) continue;
                this.calcPositions(nodeItem, rectangle2D);
            }
            this.cool(i);
        }
        this.finish(graph);
    }

    private void init(Graph graph, Rectangle2D rectangle2D) {
        this.temp = rectangle2D.getWidth() / 10.0;
        this.forceConstant = 0.75 * Math.sqrt(rectangle2D.getHeight() * rectangle2D.getWidth() / (double)graph.getNodeCount());
        Iterator iterator = graph.getNodes();
        Random random = new Random(42L);
        double d = 0.1 * rectangle2D.getWidth() / 2.0;
        double d2 = 0.1 * rectangle2D.getHeight() / 2.0;
        while (iterator.hasNext()) {
            NodeItem nodeItem = (NodeItem)iterator.next();
            FRParams fRParams = this.getParams(nodeItem);
            fRParams.loc[0] = rectangle2D.getCenterX() + random.nextDouble() * d;
            fRParams.loc[1] = rectangle2D.getCenterY() + random.nextDouble() * d2;
        }
    }

    private void finish(Graph graph) {
        Iterator iterator = graph.getNodes();
        while (iterator.hasNext()) {
            NodeItem nodeItem = (NodeItem)iterator.next();
            FRParams fRParams = this.getParams(nodeItem);
            this.setLocation(nodeItem, null, fRParams.loc[0], fRParams.loc[1]);
        }
    }

    public void calcPositions(NodeItem nodeItem, Rectangle2D rectangle2D) {
        FRParams fRParams = this.getParams(nodeItem);
        double d = Math.max(1.0E-6, Math.sqrt(fRParams.disp[0] * fRParams.disp[0] + fRParams.disp[1] * fRParams.disp[1]));
        double d2 = fRParams.disp[0] / d * Math.min(d, this.temp);
        if (Double.isNaN(d2)) {
            System.err.println("Mathematical error... (calcPositions:xDisp)");
        }
        double d3 = fRParams.disp[1] / d * Math.min(d, this.temp);
        fRParams.loc[0] = fRParams.loc[0] + d2;
        fRParams.loc[1] = fRParams.loc[1] + d3;
        double d4 = rectangle2D.getWidth() / 50.0;
        double d5 = fRParams.loc[0];
        if (d5 < rectangle2D.getMinX() + d4) {
            d5 = rectangle2D.getMinX() + d4 + Math.random() * d4 * 2.0;
        } else if (d5 > rectangle2D.getMaxX() - d4) {
            d5 = rectangle2D.getMaxX() - d4 - Math.random() * d4 * 2.0;
        }
        double d6 = fRParams.loc[1];
        if (d6 < rectangle2D.getMinY() + d4) {
            d6 = rectangle2D.getMinY() + d4 + Math.random() * d4 * 2.0;
        } else if (d6 > rectangle2D.getMaxY() - d4) {
            d6 = rectangle2D.getMaxY() - d4 - Math.random() * d4 * 2.0;
        }
        fRParams.loc[0] = d5;
        fRParams.loc[1] = d6;
    }

    public void calcAttraction(EdgeItem edgeItem) {
        NodeItem nodeItem = (NodeItem)edgeItem.getFirstNode();
        FRParams fRParams = this.getParams(nodeItem);
        NodeItem nodeItem2 = (NodeItem)edgeItem.getSecondNode();
        FRParams fRParams2 = this.getParams(nodeItem2);
        double d = fRParams.loc[0] - fRParams2.loc[0];
        double d2 = fRParams.loc[1] - fRParams2.loc[1];
        double d3 = Math.max(1.0E-6, Math.sqrt(d * d + d2 * d2));
        double d4 = d3 * d3 / this.forceConstant;
        if (Double.isNaN(d4)) {
            System.err.println("Mathematical error...");
        }
        double d5 = d / d3 * d4;
        double d6 = d2 / d3 * d4;
        fRParams.disp[0] = fRParams.disp[0] - d5;
        fRParams.disp[1] = fRParams.disp[1] - d6;
        fRParams2.disp[0] = fRParams2.disp[0] + d5;
        fRParams2.disp[1] = fRParams2.disp[1] + d6;
    }

    public void calcRepulsion(Graph graph, NodeItem nodeItem) {
        FRParams fRParams = this.getParams(nodeItem);
        fRParams.disp[0] = 0.0;
        fRParams.disp[1] = 0.0;
        Iterator iterator = graph.getNodes();
        while (iterator.hasNext()) {
            NodeItem nodeItem2 = (NodeItem)iterator.next();
            FRParams fRParams2 = this.getParams(nodeItem2);
            if (nodeItem2.isFixed() || nodeItem == nodeItem2) continue;
            double d = fRParams.loc[0] - fRParams2.loc[0];
            double d2 = fRParams.loc[1] - fRParams2.loc[1];
            double d3 = Math.max(1.0E-6, Math.sqrt(d * d + d2 * d2));
            double d4 = this.forceConstant * this.forceConstant / d3;
            if (Double.isNaN(d4)) {
                System.err.println("Mathematical error...");
            }
            fRParams.disp[0] = fRParams.disp[0] + d / d3 * d4;
            fRParams.disp[1] = fRParams.disp[1] + d2 / d3 * d4;
        }
    }

    private void cool(int n) {
        this.temp *= 1.0 - (double)n / (double)this.maxIter;
    }

    private FRParams getParams(VisualItem visualItem) {
        FRParams fRParams = (FRParams)visualItem.getVizAttribute("frParams");
        if (fRParams == null) {
            fRParams = new FRParams();
            visualItem.setVizAttribute("frParams", fRParams);
        }
        return fRParams;
    }

    public class FRParams {
        double[] loc = new double[2];
        double[] disp = new double[2];
    }
}

