/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.prefusex.layout;

import edu.berkeley.guir.prefuse.AggregateItem;
import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.NodeItem;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.action.assignment.TreeLayout;
import edu.berkeley.guir.prefuse.collections.DOIItemComparator;
import edu.berkeley.guir.prefuse.graph.TreeNode;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class IndentedTreeLayout
extends TreeLayout {
    public static final String ATTR_EXPANDED = "expanded";
    private ItemRegistry m_registry;
    private List m_entryList = new ArrayList();
    private int m_verticalInc = 15;
    private int m_indent = 16;
    private boolean m_elide = false;
    private List m_tlist = new LinkedList();
    private Comparator m_comp = new Comparator(){
        Comparator comp = new DOIItemComparator();

        public int compare(Object object, Object object2) {
            NodeItem nodeItem = ((LayoutEntry)object).nodeItem;
            NodeItem nodeItem2 = ((LayoutEntry)object2).nodeItem;
            return this.comp.compare(nodeItem, nodeItem2);
        }
    };
    private AggregateItem m_tmpAggr = null;

    public int getIndent() {
        return this.m_indent;
    }

    public void setIndent(int n) {
        this.m_indent = n;
    }

    public boolean isEliding() {
        return this.m_elide;
    }

    public void setEliding(boolean bl) {
        this.m_elide = bl;
    }

    public Point2D getLayoutAnchor(ItemRegistry itemRegistry) {
        Point2D point2D = super.getLayoutAnchor();
        if (point2D != null) {
            return point2D;
        }
        Rectangle2D rectangle2D = this.getLayoutBounds(itemRegistry);
        double d = 0.0;
        double d2 = 0.0;
        if (rectangle2D != null) {
            d = rectangle2D.getX();
            d2 = rectangle2D.getY();
        }
        return new Point2D.Double(d, d2);
    }

    public void run(ItemRegistry itemRegistry, double d) {
        this.m_registry = itemRegistry;
        this.m_tmpAggr = null;
        NodeItem nodeItem = this.getLayoutRoot(itemRegistry);
        if (nodeItem != null && nodeItem.isVisible()) {
            Rectangle2D rectangle2D = this.getLayoutBounds(itemRegistry);
            Point2D point2D = this.getLayoutAnchor(itemRegistry);
            int n = (int)Math.ceil(rectangle2D.getHeight() - point2D.getY());
            int n2 = this.calcTreeHeight(this.m_entryList, nodeItem, 0, 0);
            this.updateStartLocations(this.m_entryList);
            if (this.m_elide && n2 > n) {
                this.elide(n2, n);
            }
            this.layout(this.m_entryList, (int)Math.ceil(point2D.getY() + nodeItem.getBounds().getHeight() / 2.0), (int)Math.ceil(point2D.getX()));
        } else {
            System.err.println("IndentedTreeLayout: Tree root not visible!");
        }
        this.m_entryList.clear();
    }

    protected int calcTreeHeight(List list, NodeItem nodeItem, int n, int n2) {
        if (nodeItem != null && nodeItem.isVisible()) {
            LayoutEntry layoutEntry = new LayoutEntry(nodeItem, n2);
            layoutEntry.index = list.size();
            list.add(layoutEntry);
            n = (int)((double)n + nodeItem.getBounds().getHeight());
            if (this.isExpanded(nodeItem)) {
                Iterator iterator = nodeItem.getChildren();
                while (iterator.hasNext()) {
                    NodeItem nodeItem2 = (NodeItem)iterator.next();
                    n = this.calcTreeHeight(list, nodeItem2, n, n2 + 1);
                }
            }
        }
        return n;
    }

    protected void elide(int n, int n2) {
        TreeNode treeNode;
        int n3;
        Object object;
        ArrayList arrayList = new ArrayList(this.m_entryList);
        boolean[] blArray = new boolean[arrayList.size()];
        Collections.sort(arrayList, this.m_comp);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext() && n > n2) {
            object = (LayoutEntry)iterator.next();
            NodeItem nodeItem = ((LayoutEntry)object).nodeItem;
            int n4 = ((LayoutEntry)object).index;
            blArray[n4] = true;
            n3 = this.elisionRun(blArray, n4);
            if (n3 <= 0) continue;
            for (int i = 0; i < n3; ++i) {
                treeNode = ((LayoutEntry)this.m_entryList.get((int)(n4 + i))).nodeItem;
                n = (int)((double)n - ((VisualItem)((Object)treeNode)).getBounds().getHeight());
            }
        }
        object = null;
        n3 = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (object != null && blArray[i] || i < blArray.length - 1 && blArray[i] && blArray[i + 1]) {
                LayoutEntry layoutEntry = (LayoutEntry)this.m_entryList.get(i);
                NodeItem nodeItem = layoutEntry.nodeItem;
                treeNode = (TreeNode)nodeItem.getEntity();
                if (object == null) {
                    object = this.m_registry.getAggregateItem(treeNode, false);
                    if (object != null) {
                        this.m_registry.removeMappings((VisualItem)object);
                    }
                    object = this.m_registry.getAggregateItem(treeNode, true);
                    this.copyAttributes(nodeItem, (VisualItem)object);
                } else {
                    this.m_registry.addMapping(treeNode, (VisualItem)object);
                }
                ((AggregateItem)object).setAggregateSize(++n3);
                nodeItem.setVisible(false);
                layoutEntry.elided = true;
                layoutEntry.aggrItem = object;
                continue;
            }
            if (object == null || blArray[i]) continue;
            object = null;
            n3 = 0;
        }
    }

    private int elisionRun(boolean[] blArray, int n) {
        int n2 = blArray.length;
        if (n == 0) {
            return n2 > 1 && blArray[1] ? 1 : 0;
        }
        if (n == n2 - 1) {
            return n > 0 && blArray[n - 1] ? 1 : 0;
        }
        if (n2 >= 2 && blArray[n - 1] && blArray[n + 1]) {
            return 2;
        }
        if (n > 0 && blArray[n - 1] || n < n2 - 1 && blArray[n + 1]) {
            return 1;
        }
        return 0;
    }

    private void copyAttributes(VisualItem visualItem, VisualItem visualItem2) {
        visualItem2.setLocation(visualItem.getLocation());
        visualItem2.setEndLocation(visualItem.getEndLocation());
        visualItem2.setSize(visualItem.getSize());
        visualItem2.setEndSize(visualItem.getEndSize());
    }

    protected void updateStartLocations(List list) {
        for (int i = 0; i < list.size(); ++i) {
            LayoutEntry layoutEntry = (LayoutEntry)list.get(i);
            NodeItem nodeItem = layoutEntry.nodeItem;
            if (!nodeItem.isNewlyVisible()) continue;
            TreeNode treeNode = (TreeNode)nodeItem.getEntity();
            AggregateItem aggregateItem = this.m_registry.getAggregateItem(treeNode);
            if (aggregateItem != null && aggregateItem.isVisible()) {
                nodeItem.setLocation(aggregateItem.getEndLocation());
                continue;
            }
            TreeNode treeNode2 = treeNode.getParent();
            if (treeNode2 == null) continue;
            NodeItem nodeItem2 = this.m_registry.getNodeItem(treeNode2);
            nodeItem.setLocation(nodeItem2.getEndLocation());
        }
    }

    protected int layout(List list, int n, int n2) {
        NodeItem nodeItem = null;
        for (int i = 0; i < list.size(); ++i) {
            NodeItem nodeItem2;
            LayoutEntry layoutEntry = (LayoutEntry)list.get(i);
            if (layoutEntry.hidden) continue;
            if (layoutEntry.elided) {
                nodeItem2 = layoutEntry.aggrItem;
                if (nodeItem2 == nodeItem) continue;
                nodeItem = nodeItem2;
            } else {
                nodeItem2 = layoutEntry.nodeItem;
            }
            this.setLocation(nodeItem2, (NodeItem)nodeItem2.getParent(), layoutEntry.depth * this.m_indent + n, n2);
            n2 = (int)((double)n2 + nodeItem2.getBounds().getHeight());
        }
        return n2;
    }

    protected void setLocation(VisualItem visualItem, VisualItem visualItem2, double d, double d2) {
        super.setLocation(visualItem, visualItem2, d, d2);
        List list = null;
        if (visualItem instanceof AggregateItem) {
            list = ((AggregateItem)visualItem).getEntities();
        }
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                NodeItem nodeItem = this.m_registry.getNodeItem((TreeNode)iterator.next());
                super.setLocation(nodeItem, visualItem, d, d2);
            }
        }
    }

    private boolean isExpanded(VisualItem visualItem) {
        Boolean bl = (Boolean)visualItem.getVizAttribute(ATTR_EXPANDED);
        return bl == null ? false : bl;
    }

    private class LayoutEntry {
        NodeItem nodeItem;
        NodeItem aggrItem;
        boolean elided;
        boolean hidden;
        int index;
        int depth;

        public LayoutEntry(NodeItem nodeItem, int n) {
            this.nodeItem = nodeItem;
            this.aggrItem = null;
            this.elided = false;
            this.hidden = false;
            this.index = -1;
            this.depth = n;
        }
    }
}

