/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jam.internal.javadoc;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.AnnotationTypeElementDoc;
import com.sun.javadoc.AnnotationValue;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Type;
import org.codehaus.jam.JClass;
import org.codehaus.jam.internal.elements.ElementContext;
import org.codehaus.jam.internal.javadoc.JavadocClassBuilder;
import org.codehaus.jam.internal.javadoc.JavadocTigerDelegate;
import org.codehaus.jam.mutable.MAnnotatedElement;
import org.codehaus.jam.mutable.MAnnotation;
import org.codehaus.jam.mutable.MClass;
import org.codehaus.jam.mutable.MElement;
import org.codehaus.jam.provider.JamLogger;
import org.codehaus.jam.provider.JamServiceContext;

public final class JavadocTigerDelegateImpl_150
extends JavadocTigerDelegate {
    private static final String ANNOTATION_DEFAULTS_ENABLED_PROPERTY = "Javadoc15DelegateImpl.ANNOTATION_DEFAULTS_ENABLED_PROPERTY";
    public static boolean ANNOTATION_DEFAULTS_ENABLED = false;

    public static final void setDefaultsEnabled(boolean b) {
        ANNOTATION_DEFAULTS_ENABLED = b;
    }

    private final boolean useAnnotationDefaults() {
        return ANNOTATION_DEFAULTS_ENABLED || this.mContext != null && ((JamServiceContext)((Object)this.mContext)).getProperty(ANNOTATION_DEFAULTS_ENABLED_PROPERTY) != null;
    }

    public void init(ElementContext ctx) {
        if (this.mContext != null) {
            throw new IllegalStateException("init called more than once");
        }
        this.mContext = ctx;
        this.mLogger = ctx.getLogger();
    }

    public void init(JamLogger logger) {
        this.mLogger = logger;
    }

    public void populateAnnotationTypeIfNecessary(ClassDoc cd, MClass clazz, JavadocClassBuilder builder) {
        if (cd instanceof AnnotationTypeDoc) {
            clazz.setIsAnnotationType(true);
            AnnotationTypeElementDoc[] elements = ((AnnotationTypeDoc)cd).elements();
            for (int i = 0; i < elements.length; ++i) {
                builder.addMethod(clazz, (MethodDoc)elements[i]);
            }
        }
    }

    public void extractAnnotations(MAnnotatedElement dest, ProgramElementDoc src) {
        if (this.mContext == null) {
            throw new IllegalStateException("init not called");
        }
        if (dest == null) {
            throw new IllegalArgumentException("null dest");
        }
        if (src == null) {
            throw new IllegalArgumentException("null src");
        }
        this.extractAnnotations(dest, src.annotations(), src.position());
    }

    public void extractAnnotations(MAnnotatedElement dest, ExecutableMemberDoc method, Parameter src) {
        this.extractAnnotations(dest, src.annotations(), method.position());
    }

    public boolean isEnum(ClassDoc cd) {
        return cd.isEnum();
    }

    private void extractAnnotations(MAnnotatedElement dest, AnnotationDesc[] anns, SourcePosition sp) {
        if (anns == null) {
            return;
        }
        for (int i = 0; i < anns.length; ++i) {
            String tn = JavadocClassBuilder.getFdFor((Type)anns[i].annotationType());
            MAnnotation destAnn = dest.findOrCreateAnnotation(tn);
            this.populateAnnotation(destAnn, anns[i], sp);
        }
    }

    private void populateAnnotation(MAnnotation dest, AnnotationDesc src, SourcePosition sp) {
        if (sp != null) {
            JavadocClassBuilder.addSourcePosition((MElement)dest, sp);
        }
        AnnotationDesc.ElementValuePair[] mvps = src.elementValues();
        for (int i = 0; i < mvps.length; ++i) {
            Type jmt = mvps[i].element().returnType();
            String name = mvps[i].element().name();
            AnnotationValue aval = mvps[i].value();
            this.setAnnotationValue(name, jmt, aval, dest, sp);
        }
        if (!this.useAnnotationDefaults()) {
            return;
        }
        AnnotationTypeDoc atd = src.annotationType();
        AnnotationTypeElementDoc[] elements = atd.elements();
        for (int i = 0; i < elements.length; ++i) {
            AnnotationValue value = elements[i].defaultValue();
            if (value == null) continue;
            String name = elements[i].name();
            System.out.println("default value named '" + name + "'  = " + " " + value + "  " + value.getClass() + " " + dest.getValue(name));
            if (dest.getValue(name) != null) continue;
            this.setAnnotationValue(name, elements[i].returnType(), value, dest, sp);
        }
    }

    private void setAnnotationValue(String memberName, Type returnType, AnnotationValue aval, MAnnotation dest, SourcePosition sp) {
        Object valueObj;
        String typeName = this.getFdFor(returnType);
        try {
            valueObj = aval.value();
        }
        catch (NullPointerException npe) {
            this.mLogger.warning("Encountered a known javadoc bug which usually \nindicates a syntax error in an annotation value declaration.\nThe value is being ignored.\n[file=" + sp.file() + ", line=" + sp.line() + "]");
            return;
        }
        if (this.mLogger.isVerbose(this)) {
            this.mLogger.verbose(memberName + " is a " + typeName + " with valueObj " + valueObj + ", class is " + valueObj.getClass());
        }
        if (valueObj instanceof AnnotationDesc) {
            MAnnotation nested = dest.createNestedValue(memberName, typeName);
            this.populateAnnotation(nested, (AnnotationDesc)valueObj, sp);
        } else if (valueObj instanceof Number || valueObj instanceof Boolean) {
            String tn = JavadocClassBuilder.getFdFor(returnType);
            JClass type = this.mContext.getClassLoader().loadClass(tn);
            dest.setSimpleValue(memberName, valueObj, type);
        } else if (valueObj instanceof FieldDoc) {
            String tn = JavadocClassBuilder.getFdFor((Type)((FieldDoc)valueObj).containingClass());
            JClass type = this.mContext.getClassLoader().loadClass(tn);
            String val = ((FieldDoc)valueObj).name();
            dest.setSimpleValue(memberName, val, type);
        } else if (valueObj instanceof ClassDoc) {
            String tn = JavadocClassBuilder.getFdFor((Type)((FieldDoc)valueObj).containingClass());
            JClass clazz = this.mContext.getClassLoader().loadClass(tn);
            dest.setSimpleValue(memberName, clazz, this.loadClass(JClass.class));
        } else if (valueObj instanceof String) {
            String v = ((String)valueObj).trim();
            if (v.startsWith("\"") && v.endsWith("\"")) {
                valueObj = v.substring(1, v.length() - 1);
            }
            dest.setSimpleValue(memberName, valueObj, this.loadClass(String.class));
        } else if (valueObj instanceof AnnotationValue[]) {
            this.populateArrayMember(dest, memberName, returnType, (AnnotationValue[])valueObj, sp);
        } else {
            this.mLogger.error("Value of annotation member " + memberName + " is " + "of an unexpected type: " + valueObj.getClass() + "   [" + valueObj + "]");
        }
    }

    private void populateArrayMember(MAnnotation dest, String memberName, Type returnType, AnnotationValue[] annValueArray, SourcePosition sp) {
        if (sp != null) {
            JavadocClassBuilder.addSourcePosition((MElement)dest, sp);
        }
        if (annValueArray.length == 0) {
            Object[] value = new Object[]{};
            dest.setSimpleValue(memberName, value, this.loadClass(returnType));
            return;
        }
        Object[] valueArray = new Object[annValueArray.length];
        for (int i = 0; i < valueArray.length; ++i) {
            try {
                valueArray[i] = annValueArray[i].value();
                if (valueArray[i] != null) continue;
                this.mLogger.error("Javadoc provided an array annotation member value which contains [file=" + sp.file() + ", line=" + sp.line() + "]");
                return;
            }
            catch (NullPointerException npe) {
                this.mLogger.warning("Encountered a known javadoc bug which usually \nindicates a syntax error in an annotation value declaration.\nThe value is being ignored.\n[file=" + sp.file() + ", line=" + sp.line() + "]");
                return;
            }
        }
        if (valueArray[0] instanceof AnnotationDesc) {
            String annType = this.getFdFor((Type)((AnnotationDesc)valueArray[0]).annotationType());
            MAnnotation[] anns = dest.createNestedValueArray(memberName, annType, valueArray.length);
            for (int i = 0; i < anns.length; ++i) {
                this.populateAnnotation(anns[i], (AnnotationDesc)valueArray[i], sp);
            }
        } else if (valueArray[0] instanceof Number || valueArray[0] instanceof Boolean) {
            JClass type = this.loadClass(returnType);
            dest.setSimpleValue(memberName, annValueArray, type);
        } else if (valueArray[0] instanceof FieldDoc) {
            String enumTypeName = JavadocClassBuilder.getFdFor((Type)((FieldDoc)valueArray[0]).containingClass());
            JClass memberType = this.loadClass("[L" + enumTypeName + ";");
            String[] value = new String[valueArray.length];
            for (int i = 0; i < valueArray.length; ++i) {
                value[i] = ((FieldDoc)valueArray[i]).name();
            }
            dest.setSimpleValue(memberName, value, memberType);
        } else if (valueArray[0] instanceof ClassDoc) {
            JClass[] value = new JClass[valueArray.length];
            for (int i = 0; i < value.length; ++i) {
                value[i] = this.loadClass((Type)((ClassDoc)valueArray[0]));
            }
            dest.setSimpleValue(memberName, value, this.loadClass(JClass[].class));
        } else if (valueArray[0] instanceof String) {
            String[] value = new String[valueArray.length];
            for (int i = 0; i < value.length; ++i) {
                String v = ((String)valueArray[i]).trim();
                if (v.startsWith("\"") && v.endsWith("\"")) {
                    v = v.substring(1, v.length() - 1);
                }
                value[i] = v;
            }
            dest.setSimpleValue(memberName, value, this.loadClass(String[].class));
        } else {
            this.mLogger.error("Value of array annotation member " + memberName + " is of an unexpected type: " + valueArray[0].getClass() + "   [" + valueArray[0] + "]");
        }
    }

    private String getFdFor(Type t) {
        return JavadocClassBuilder.getFdFor(t);
    }

    private JClass loadClass(Type type) {
        return this.loadClass(this.getFdFor(type));
    }

    private JClass loadClass(Class clazz) {
        return this.loadClass(clazz.getName());
    }

    private JClass loadClass(String fd) {
        return this.mContext.getClassLoader().loadClass(fd);
    }
}

