/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.io.Serializable;
import org.jfree.chart.axis.NumberTickUnit;

public class SymbolicTickUnit
extends NumberTickUnit
implements Serializable {
    private static final long serialVersionUID = -4836679837074745805L;
    private String[] symbolicValue;

    public SymbolicTickUnit(double size, String[] sv) {
        super(size, null);
        this.symbolicValue = new String[sv.length];
        System.arraycopy(sv, 0, this.symbolicValue, 0, sv.length);
    }

    public String valueToString(double value) {
        if (value < 0.0 || value >= (double)this.symbolicValue.length) {
            throw new IllegalArgumentException("The value " + value + " does not have a corresponding symbolic value");
        }
        return this.symbolicValue[(int)value];
    }

    public int getSymbolCount() {
        return this.symbolicValue.length;
    }
}

