/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.io;

import com.mockobjects.MockObject;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import junit.framework.AssertionFailedError;

public class MockFileInputStream
extends FileInputStream {
    public static final String KNOWN_FILE = "c:\\autoexec.bat";
    private String myContents = "";
    private int myIndex = 0;

    private MockFileInputStream() throws FileNotFoundException {
        super(KNOWN_FILE);
    }

    public static MockFileInputStream newMockFileInputStream() {
        try {
            return new MockFileInputStream();
        }
        catch (FileNotFoundException e) {
            throw new AssertionFailedError("couldn't create MockFileInputStream (requires known file: c:\\autoexec.bat) " + e);
        }
    }

    public int available() throws IOException {
        return this.myContents.length();
    }

    public void mark(int readlimit) {
        MockObject.notYetImplemented((String)"MockFileInputStream.mark");
    }

    public int read() throws IOException {
        if (this.myIndex == this.myContents.length()) {
            return -1;
        }
        return this.myContents.charAt(this.myIndex++);
    }

    public int read(byte[] b) throws IOException {
        if (this.myIndex == this.myContents.length()) {
            return -1;
        }
        for (int i = 0; i < this.myContents.length(); ++i) {
            b[i] = (byte)this.read();
        }
        return this.myContents.length();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.myIndex == this.myContents.length()) {
            return -1;
        }
        int bytesRead = 0;
        for (int i = off; i < len; ++i) {
            b[i] = (byte)this.myContents.charAt(this.myIndex);
            ++bytesRead;
            ++this.myIndex;
            if (this.myIndex == this.myContents.length()) break;
        }
        return bytesRead;
    }

    public void setupContents(String contents) {
        this.myContents = contents;
        this.myIndex = 0;
    }

    public long skip(long n) throws IOException {
        MockObject.notYetImplemented((String)"MockFileInputStream.skip");
        return -1L;
    }
}

