/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.io;

import com.mockobjects.ExpectationCounter;
import com.mockobjects.ExpectationSegment;
import com.mockobjects.util.Verifier;
import java.io.OutputStream;
import java.io.PrintStream;

public class MockPrintStream
extends PrintStream {
    private ExpectationCounter myPrintlnCalls = new ExpectationCounter("MockPrintStream.println calls");
    private ExpectationSegment mySegment = new ExpectationSegment("String segment");
    private PrintStream myOldErrorStream;

    public MockPrintStream() {
        this((OutputStream)null);
    }

    public MockPrintStream(OutputStream out) {
        super(out);
    }

    public MockPrintStream(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public void becomeErrorStream() {
        this.myOldErrorStream = System.err;
        System.setErr(this);
    }

    public void println(Object anObject) {
        this.myPrintlnCalls.inc();
    }

    public void println(String aString) {
        this.println((Object)aString);
        this.mySegment.setActual(aString);
    }

    public void restoreErrorStream() {
        System.setErr(this.myOldErrorStream);
    }

    public void setExpectedPrintlnCalls(int calls) {
        this.myPrintlnCalls.setExpected(calls);
    }

    public void setExpectedStringSegment(String aString) {
        this.mySegment.setExpected(aString);
    }

    public void verify() {
        Verifier.verifyObject((Object)this);
    }
}

