/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.io;

import com.mockobjects.ExpectationCounter;
import com.mockobjects.ExpectationSegment;
import com.mockobjects.Verifiable;
import com.mockobjects.util.Verifier;
import java.io.IOException;
import java.io.Writer;

public class MockWriter
extends Writer
implements Verifiable {
    private ExpectationSegment segment = new ExpectationSegment("String segment");
    private ExpectationCounter flushCallsCount = new ExpectationCounter("flush calls");
    private ExpectationCounter closeCallsCount = new ExpectationCounter("close calls");
    private boolean writeShouldThrowException = false;
    private boolean flushShouldThrowException = false;
    private boolean closeShouldThrowException = false;

    public MockWriter() {
        super(new Object());
    }

    public void setWriteShouldThrowException() {
        this.writeShouldThrowException = true;
    }

    public void setFlushShouldThrowException() {
        this.flushShouldThrowException = true;
    }

    public void setCloseShouldThrowException() {
        this.closeShouldThrowException = true;
    }

    public void setExpectedFlushCalls(int calls) {
        this.flushCallsCount.setExpected(calls);
    }

    public void setExpectedCloseCalls(int calls) {
        this.closeCallsCount.setExpected(calls);
    }

    public void setExpectedSegment(String aString) {
        this.segment.setExpected(aString);
    }

    public void setFailOnVerify() {
        this.segment.setFailOnVerify();
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.writeShouldThrowException) {
            throw new IOException("Mock Exception");
        }
        this.segment.setActual(new String(cbuf, off, len));
    }

    public void flush() throws IOException {
        this.flushCallsCount.inc();
        if (this.flushShouldThrowException) {
            throw new IOException("Mock Exception");
        }
    }

    public void close() throws IOException {
        this.closeCallsCount.inc();
        if (this.closeShouldThrowException) {
            throw new IOException("Mock Exception");
        }
    }

    public void verify() {
        Verifier.verifyObject((Object)this);
    }
}

