/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jgraph.JGraph;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.Edge;
import org.jgraph.graph.EdgeRenderer;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.PortView;
import org.jgraph.plaf.GraphUI;
import org.jgraph.plaf.basic.BasicGraphUI;

public class EdgeView
extends AbstractCellView {
    public static EdgeRenderer renderer = new EdgeRenderer();
    protected List points;
    protected CellView source;
    protected CellView target;
    protected Point labelPosition;
    public Shape beginShape;
    public Shape endShape;
    public Shape lineShape;
    public transient GeneralPath sharedPath = null;
    protected Rectangle2D cachedLabelBounds = null;
    protected Rectangle2D cachedBounds = null;

    public EdgeView(Object object, JGraph jGraph, CellMapper cellMapper) {
        super(object, jGraph, cellMapper);
    }

    public void refresh(boolean bl) {
        super.refresh(bl);
        if (this.points != null) {
            Object object = this.getModel().getSource(this.cell);
            Object object2 = this.getModel().getTarget(this.cell);
            this.setSource(this.mapper.getMapping(object, bl));
            this.setTarget(this.mapper.getMapping(object2, bl));
            Edge.Routing routing = GraphConstants.getRouting(this.allAttributes);
            if (routing != null) {
                routing.route(this, this.points);
            }
        }
    }

    public void update() {
        super.update();
        this.points = GraphConstants.getPoints(this.allAttributes);
        this.labelPosition = GraphConstants.getLabelPosition(this.allAttributes);
        Edge.Routing routing = GraphConstants.getRouting(this.allAttributes);
        if (routing != null) {
            routing.route(this, this.points);
        }
        if (this.getModel().getSource(this.cell) != null) {
            this.setSource(this.getSource());
        }
        if (this.getModel().getTarget(this.cell) != null) {
            this.setTarget(this.getTarget());
        }
        this.beginShape = null;
        this.endShape = null;
        this.lineShape = null;
        this.sharedPath = null;
        this.cachedBounds = null;
        this.cachedLabelBounds = null;
    }

    void invalidate() {
        this.sharedPath = null;
        this.cachedBounds = null;
        this.cachedLabelBounds = null;
    }

    public Shape getShape() {
        if (this.sharedPath != null) {
            return this.sharedPath;
        }
        this.sharedPath = (GeneralPath)this.getEdgeRenderer().createShape();
        return this.sharedPath;
    }

    public Rectangle2D getLabelBounds() {
        if (this.cachedLabelBounds != null) {
            return this.cachedLabelBounds;
        }
        this.cachedLabelBounds = this.getEdgeRenderer().getLabelBounds(this);
        return this.cachedLabelBounds;
    }

    public boolean intersects(Graphics graphics, Rectangle2D rectangle2D) {
        Rectangle rectangle = new Rectangle((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        return this.getEdgeRenderer().intersects(graphics, this, rectangle);
    }

    public Rectangle2D getBounds() {
        if (this.cachedBounds != null) {
            return this.cachedBounds;
        }
        this.cachedBounds = this.getEdgeRenderer().getBounds(this);
        return this.cachedBounds;
    }

    public EdgeRenderer getEdgeRenderer() {
        return (EdgeRenderer)this.getRenderer();
    }

    public CellViewRenderer getRenderer() {
        return renderer;
    }

    public CellHandle getHandle(GraphContext graphContext) {
        return new EdgeHandle(this, graphContext);
    }

    public CellView getSource() {
        return this.source;
    }

    public void setSource(CellView cellView) {
        this.source = cellView;
        if (this.source != null) {
            this.points.set(0, this.source);
        } else {
            this.points.set(0, this.getPoint(0));
        }
        this.invalidate();
    }

    public CellView getTarget() {
        return this.target;
    }

    public void setTarget(CellView cellView) {
        this.target = cellView;
        int n = this.points.size() - 1;
        if (this.target != null) {
            this.points.set(n, this.target);
        } else {
            this.points.set(n, this.getPoint(n));
        }
        this.invalidate();
    }

    public Point2D getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(Point2D point2D) {
        this.labelPosition.setLocation(point2D);
        this.invalidate();
    }

    public List getPoints() {
        return this.points;
    }

    public int getPointCount() {
        return this.points.size();
    }

    public Point2D getPoint(int n) {
        Object e = this.points.get(n);
        if (e instanceof PortView) {
            return ((PortView)e).getLocation(this);
        }
        if (e instanceof CellView) {
            Rectangle2D rectangle2D = ((CellView)e).getBounds();
            return this.getAttributes().createPoint(rectangle2D.getX(), rectangle2D.getY());
        }
        if (e instanceof Point2D) {
            return (Point2D)e;
        }
        return null;
    }

    public void setPoint(int n, Point2D point2D) {
        this.points.set(n, point2D);
        this.invalidate();
    }

    public void addPoint(int n, Point2D point2D) {
        this.points.add(n, point2D);
        this.invalidate();
    }

    public void removePoint(int n) {
        this.points.remove(n);
        this.invalidate();
    }

    public static double getLength(CellView cellView) {
        double d = 1.0;
        if (cellView instanceof EdgeView) {
            EdgeView edgeView = (EdgeView)cellView;
            Point2D point2D = null;
            Point2D point2D2 = null;
            int n = 0;
            while (n < edgeView.getPointCount()) {
                point2D2 = edgeView.getPoint(n);
                if (point2D != null) {
                    d += point2D.distance(point2D2);
                }
                point2D = point2D2;
                ++n;
            }
        }
        return d;
    }

    public static class EdgeHandle
    implements CellHandle,
    Serializable {
        protected JGraph graph;
        protected EdgeView edge;
        protected EdgeView orig;
        protected boolean label = false;
        protected boolean source = false;
        protected boolean target = false;
        protected Point2D currentPoint;
        protected transient Rectangle2D[] r;
        protected transient Rectangle2D loc;
        protected boolean firstOverlayCall = true;
        protected boolean isEdgeConnectable = true;
        protected EdgeView relevantEdge = null;

        public EdgeHandle(EdgeView edgeView, GraphContext graphContext) {
            this.graph = graphContext.getGraph();
            this.edge = edgeView;
            this.loc = new Rectangle();
            this.orig = (EdgeView)this.graph.getGraphLayoutCache().getMapping(edgeView.getCell(), false);
            this.reloadPoints(this.orig);
            this.isEdgeConnectable = GraphConstants.isConnectable(edgeView.getAllAttributes());
        }

        protected void reloadPoints(EdgeView edgeView) {
            this.relevantEdge = edgeView;
            this.r = new Rectangle[edgeView.getPointCount()];
            int n = 0;
            while (n < this.r.length) {
                this.r[n] = new Rectangle();
                ++n;
            }
            this.invalidate();
        }

        public void paint(Graphics graphics) {
            this.invalidate();
            int n = 0;
            while (n < this.r.length) {
                if (this.isEdgeConnectable) {
                    graphics.setColor(this.graph.getHandleColor());
                } else {
                    graphics.setColor(this.graph.getLockedHandleColor());
                }
                graphics.fill3DRect((int)this.r[n].getX(), (int)this.r[n].getY(), (int)this.r[n].getWidth(), (int)this.r[n].getHeight(), true);
                CellView cellView = null;
                if (n == 0 && this.edge.getSource() != null) {
                    cellView = this.edge.getSource();
                } else if (n == this.r.length - 1 && this.edge.getTarget() != null) {
                    cellView = this.edge.getTarget();
                }
                if (cellView != null) {
                    graphics.setColor(this.graph.getLockedHandleColor());
                    Point2D point2D = GraphConstants.getOffset(cellView.getAllAttributes());
                    if (point2D != null) {
                        graphics.drawLine((int)this.r[n].getX() + 1, (int)this.r[n].getY() + 1, (int)(this.r[n].getX() + this.r[n].getWidth()) - 3, (int)(this.r[n].getY() + this.r[n].getHeight()) - 3);
                        graphics.drawLine((int)this.r[n].getX() + 1, (int)(this.r[n].getY() + this.r[n].getHeight()) - 3, (int)(this.r[n].getX() + this.r[n].getWidth()) - 3, (int)this.r[n].getY() + 1);
                    } else {
                        graphics.drawRect((int)this.r[n].getX() + 2, (int)this.r[n].getY() + 2, (int)this.r[n].getWidth() - 5, (int)this.r[n].getHeight() - 5);
                    }
                }
                ++n;
            }
        }

        public void overlay(Graphics graphics) {
            if (this.edge != null && !this.firstOverlayCall) {
                graphics.setColor(this.graph.getForeground());
                graphics.setXORMode(this.graph.getBackground().darker());
                Graphics2D graphics2D = (Graphics2D)graphics;
                AffineTransform affineTransform = graphics2D.getTransform();
                graphics2D.scale(this.graph.getScale(), this.graph.getScale());
                this.graph.getUI().paintCell(graphics, this.edge, this.edge.getBounds(), true);
                graphics2D.setTransform(affineTransform);
                if (this.isSourceEditing() && this.edge.getSource() != null) {
                    this.paintPort(graphics, this.edge.getSource());
                } else if (this.isTargetEditing() && this.edge.getTarget() != null) {
                    this.paintPort(graphics, this.edge.getTarget());
                }
            }
            this.firstOverlayCall = false;
        }

        protected void paintPort(Graphics graphics, CellView cellView) {
            boolean bl = GraphConstants.getOffset(cellView.getAllAttributes()) != null;
            Rectangle2D rectangle2D = bl ? cellView.getBounds() : cellView.getParentView().getBounds();
            rectangle2D = this.graph.toScreen((Rectangle2D)rectangle2D.clone());
            int n = 3;
            rectangle2D.setFrame(rectangle2D.getX() - (double)n, rectangle2D.getY() - (double)n, rectangle2D.getWidth() + (double)(2 * n), rectangle2D.getHeight() + (double)(2 * n));
            this.graph.getUI().paintCell(graphics, cellView, rectangle2D, true);
        }

        protected boolean snap(boolean bl, Point2D point2D) {
            CellView cellView;
            boolean bl2 = this.graph.isConnectable() && this.isEdgeConnectable;
            Object object = this.graph.getPortForLocation(point2D.getX(), point2D.getY());
            if (object != null && bl2 && GraphConstants.isConnectable((cellView = this.graph.getGraphLayoutCache().getMapping(object, false)).getParentView().getAllAttributes())) {
                Object object2 = this.edge.getCell();
                if (bl && this.edge.getSource() != cellView && this.edge.getGraph().getModel().acceptsSource(object2, object)) {
                    this.overlay(this.graph.getGraphics());
                    this.edge.setSource(cellView);
                    this.edge.update();
                    this.overlay(this.graph.getGraphics());
                } else if (!bl && this.edge.getTarget() != cellView && this.edge.getGraph().getModel().acceptsTarget(object2, object)) {
                    this.overlay(this.graph.getGraphics());
                    this.edge.setTarget(cellView);
                    this.edge.update();
                    this.overlay(this.graph.getGraphics());
                }
                return cellView != null;
            }
            return false;
        }

        public boolean isConstrainedMoveEvent(MouseEvent mouseEvent) {
            GraphUI graphUI = this.graph.getUI();
            if (graphUI instanceof BasicGraphUI) {
                return ((BasicGraphUI)graphUI).isConstrainedMoveEvent(mouseEvent);
            }
            return false;
        }

        public boolean isAddPointEvent(MouseEvent mouseEvent) {
            return SwingUtilities.isRightMouseButton(mouseEvent);
        }

        public boolean isRemovePointEvent(MouseEvent mouseEvent) {
            return SwingUtilities.isRightMouseButton(mouseEvent);
        }

        protected boolean isSourceEditing() {
            return this.source;
        }

        protected boolean isTargetEditing() {
            return this.target;
        }

        protected boolean isEditing() {
            return this.source || this.target || this.label || this.currentPoint != null;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = 0;
            while (n < this.r.length) {
                if (this.r[n].contains(mouseEvent.getPoint())) {
                    this.graph.setCursor(new Cursor(1));
                    mouseEvent.consume();
                    return;
                }
                ++n;
            }
            if (this.loc.contains(mouseEvent.getPoint()) && this.graph.isMoveable() && GraphConstants.isMoveable(this.edge.getAllAttributes())) {
                this.graph.setCursor(new Cursor(12));
                mouseEvent.consume();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            boolean bl = this.graph.isBendable() && GraphConstants.isBendable(this.edge.getAllAttributes());
            boolean bl2 = this.graph.isDisconnectable() && GraphConstants.isDisconnectable(this.orig.getAllAttributes());
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = 0;
            n3 = 0;
            while (n3 < this.r.length) {
                if (this.r[n3].contains(n, n2)) {
                    this.currentPoint = this.edge.getPoint(n3);
                    this.source = n3 == 0 && (this.edge.getSource() == null || bl2 && GraphConstants.isDisconnectable(this.edge.getSource().getParentView().getAllAttributes()));
                    this.target = n3 == this.r.length - 1 && (this.edge.getTarget() == null || bl2 && GraphConstants.isDisconnectable(this.edge.getTarget().getParentView().getAllAttributes()));
                    break;
                }
                ++n3;
            }
            if (!this.isEditing() && this.graph.isMoveable() && GraphConstants.isMoveable(this.edge.getAllAttributes()) && this.loc != null && this.loc.contains(n, n2) && !this.isAddPointEvent(mouseEvent) && !this.isRemovePointEvent(mouseEvent)) {
                if (mouseEvent.getClickCount() == this.graph.getEditClickCount()) {
                    this.graph.startEditingAtCell(this.edge);
                } else {
                    this.label = true;
                }
            }
            if (this.isRemovePointEvent(mouseEvent) && this.currentPoint != null && !this.source && !this.target && bl) {
                this.edge.removePoint(n3);
                this.mouseReleased(mouseEvent);
            } else if (this.isAddPointEvent(mouseEvent) && !this.isEditing() && bl) {
                int n4 = this.graph.getHandleSize();
                Rectangle2D rectangle2D = this.graph.fromScreen(new Rectangle(n - n4, n2 - n4, 2 * n4, 2 * n4));
                if (this.edge.intersects(this.graph.getGraphics(), rectangle2D)) {
                    Point2D point2D = this.graph.fromScreen(this.graph.snap(new Point(mouseEvent.getPoint())));
                    double d = Double.MAX_VALUE;
                    double d2 = 0.0;
                    int n5 = 0;
                    while (n5 < this.edge.getPointCount() - 1) {
                        Point2D point2D2;
                        Point2D point2D3 = this.edge.getPoint(n5);
                        d2 = new Line2D.Double(point2D3, point2D2 = this.edge.getPoint(n5 + 1)).ptLineDistSq(point2D);
                        if (d2 < d) {
                            d = d2;
                            n3 = n5 + 1;
                        }
                        ++n5;
                    }
                    this.edge.addPoint(n3, point2D);
                    this.currentPoint = point2D;
                    this.reloadPoints(this.edge);
                    this.paint(this.graph.getGraphics());
                }
            }
            if (this.isEditing()) {
                mouseEvent.consume();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Point2D point2D = this.graph.fromScreen(new Point(mouseEvent.getPoint()));
            if (this.label) {
                Rectangle2D rectangle2D = this.edge.getBounds();
                if (rectangle2D != null) {
                    Point2D point2D2 = this.edge.getPoint(0);
                    Point2D point2D3 = this.edge.getPoint(this.edge.getPointCount() - 1);
                    double d = point2D.getX() - rectangle2D.getX();
                    if (point2D2.getX() > point2D3.getX()) {
                        d = rectangle2D.getX() + rectangle2D.getWidth() - point2D.getX();
                    }
                    double d2 = point2D.getY() - rectangle2D.getY();
                    if (point2D2.getY() > point2D3.getY()) {
                        d2 = rectangle2D.getY() + rectangle2D.getHeight() - point2D.getY();
                    }
                    double d3 = 1.0;
                    if (rectangle2D.getWidth() != 0.0) {
                        d3 = 1000.0 / rectangle2D.getWidth();
                    }
                    double d4 = 1.0;
                    if (rectangle2D.getHeight() != 0.0) {
                        d4 = 1000.0 / rectangle2D.getHeight();
                    }
                    point2D = this.edge.getAttributes().createPoint(d * d3, d2 * d4);
                    this.overlay(this.graph.getGraphics());
                    this.edge.setLabelPosition(point2D);
                    this.edge.update();
                    this.overlay(this.graph.getGraphics());
                }
            } else if (!(!this.isEditing() || this.source && this.snap(true, point2D) || this.target && this.snap(false, point2D) || !(this.source && this.edge.getGraph().getModel().acceptsSource(this.edge.getCell(), null) || this.target && this.edge.getGraph().getModel().acceptsTarget(this.edge.getCell(), null)) && (this.source || this.target))) {
                this.overlay(this.graph.getGraphics());
                point2D = this.graph.fromScreen(this.graph.snap(new Point(mouseEvent.getPoint())));
                if (this.isConstrainedMoveEvent(mouseEvent)) {
                    EdgeView edgeView = (EdgeView)this.graph.getGraphLayoutCache().getMapping(this.edge.getCell(), false);
                    int n = 0;
                    if (this.target) {
                        n = edgeView.getPointCount() - 1;
                    }
                    Point2D point2D4 = edgeView.getPoint(n);
                    double d = point2D.getX() - point2D4.getX();
                    double d5 = point2D.getY() - point2D4.getY();
                    if (Math.abs(d) < Math.abs(d5)) {
                        point2D.setLocation(point2D4.getX(), point2D.getY());
                    } else {
                        point2D.setLocation(point2D.getX(), point2D4.getY());
                    }
                }
                point2D.setLocation(Math.max(0.0, point2D.getX()), Math.max(0.0, point2D.getY()));
                this.currentPoint.setLocation(point2D);
                if (this.source) {
                    this.edge.setPoint(0, point2D);
                    this.edge.setSource(null);
                } else if (this.target) {
                    this.edge.setPoint(this.edge.getPointCount() - 1, point2D);
                    this.edge.setTarget(null);
                }
                this.edge.update();
                this.overlay(this.graph.getGraphics());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            boolean bl = mouseEvent.isControlDown() && this.graph.isCloneable();
            ConnectionSet connectionSet = this.createConnectionSet(this.edge, this.edge.getCell(), bl);
            Map map = GraphConstants.createAttributes(new CellView[]{this.edge}, null);
            if (bl) {
                Map map2 = this.graph.cloneCells(new Object[]{this.edge.getCell()});
                map = GraphConstants.replaceKeys(map2, map);
                connectionSet = connectionSet.clone(map2);
                this.graph.getGraphLayoutCache().insert(map2.values().toArray(), map, connectionSet, null, null);
            } else {
                this.graph.getGraphLayoutCache().edit(map, connectionSet, null, null);
            }
            mouseEvent.consume();
        }

        protected ConnectionSet createConnectionSet(EdgeView edgeView, Object object, boolean bl) {
            ConnectionSet connectionSet = new ConnectionSet();
            Object object2 = null;
            Object object3 = null;
            if (edgeView.getSource() != null) {
                object2 = edgeView.getSource().getCell();
            }
            if (edgeView.getTarget() != null) {
                object3 = edgeView.getTarget().getCell();
            }
            if (bl || object2 != edgeView.getGraph().getModel().getSource(object)) {
                connectionSet.connect(object, object2, true);
            }
            if (bl || object3 != edgeView.getGraph().getModel().getTarget(object)) {
                connectionSet.connect(object, object3, false);
            }
            return connectionSet;
        }

        protected void invalidate() {
            EdgeView edgeView = this.relevantEdge;
            int n = this.graph.getHandleSize();
            EdgeRenderer edgeRenderer = (EdgeRenderer)this.edge.getRenderer();
            int n2 = 0;
            while (n2 < this.r.length) {
                Point2D point2D = this.graph.toScreen(this.edge.getAttributes().createPoint(edgeView.getPoint(n2)));
                this.r[n2].setFrame(point2D.getX() - (double)n, point2D.getY() - (double)n, 2 * n, 2 * n);
                point2D = this.graph.toScreen(edgeRenderer.getLabelPosition(edgeView));
                Dimension dimension = edgeRenderer.getLabelSize(edgeView);
                if (point2D != null && dimension != null) {
                    Point2D point2D2 = this.graph.toScreen(this.edge.getAttributes().createPoint(dimension.width, dimension.height));
                    this.loc.setFrame(point2D.getX() - point2D2.getX() / 2.0, point2D.getY() - point2D2.getY() / 2.0, point2D2.getX(), point2D2.getY());
                }
                ++n2;
            }
        }
    }
}

