/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.VertexView;

public class VertexRenderer
extends JLabel
implements CellViewRenderer,
Serializable {
    protected boolean hideGroups = true;
    protected transient JGraph graph;
    protected transient VertexView view;
    protected transient boolean hasFocus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient boolean opaque;
    protected transient boolean childrenSelected;
    protected transient Color defaultForeground = UIManager.getColor("Tree.textForeground");
    protected transient Color defaultBackground = UIManager.getColor("Tree.textBackground");
    protected transient Color bordercolor;
    protected transient int borderWidth;
    transient boolean isDoubleBuffered = false;

    public VertexRenderer() {
    }

    public VertexRenderer(boolean bl) {
        this.hideGroups = bl;
    }

    public Component getRendererComponent(JGraph jGraph, CellView cellView, boolean bl, boolean bl2, boolean bl3) {
        this.graph = jGraph;
        this.isDoubleBuffered = jGraph.isDoubleBuffered();
        if (cellView instanceof VertexView) {
            this.view = (VertexView)cellView;
            this.setComponentOrientation(jGraph.getComponentOrientation());
            if (jGraph.getEditingCell() != cellView.getCell()) {
                String string = jGraph.convertValueToString(cellView);
                if (string != null) {
                    this.setText(string.toString());
                } else {
                    this.setText(null);
                }
            } else {
                this.setText(null);
            }
            this.graph = jGraph;
            this.hasFocus = bl2;
            this.childrenSelected = jGraph.getSelectionModel().isChildrenSelected(cellView.getCell());
            this.selected = bl;
            this.preview = bl3;
            if (this.view.isLeaf() || !this.hideGroups) {
                this.installAttributes(cellView);
            } else {
                this.setText(null);
                this.setBorder(null);
                this.setOpaque(false);
                this.setIcon(null);
            }
            return this;
        }
        return null;
    }

    protected void installAttributes(CellView cellView) {
        Color color;
        AttributeMap attributeMap = cellView.getAllAttributes();
        this.setIcon(GraphConstants.getIcon(attributeMap));
        this.setOpaque(GraphConstants.isOpaque(attributeMap));
        this.setBorder(GraphConstants.getBorder(attributeMap));
        this.setVerticalAlignment(GraphConstants.getVerticalAlignment(attributeMap));
        this.setHorizontalAlignment(GraphConstants.getHorizontalAlignment(attributeMap));
        this.setVerticalTextPosition(GraphConstants.getVerticalTextPosition(attributeMap));
        this.setHorizontalTextPosition(GraphConstants.getHorizontalTextPosition(attributeMap));
        this.bordercolor = GraphConstants.getBorderColor(attributeMap);
        this.borderWidth = Math.max(1, Math.round(GraphConstants.getLineWidth(attributeMap)));
        if (this.getBorder() == null && this.bordercolor != null) {
            this.setBorder(BorderFactory.createLineBorder(this.bordercolor, this.borderWidth));
        }
        this.setForeground((color = GraphConstants.getForeground(attributeMap)) != null ? color : this.defaultForeground);
        Color color2 = GraphConstants.getBackground(attributeMap);
        this.setBackground(color2 != null ? color2 : this.defaultBackground);
        this.setFont(GraphConstants.getFont(attributeMap));
    }

    public void paint(Graphics graphics) {
        try {
            super.paint(graphics);
            this.paintSelectionBorder(graphics);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    protected void paintSelectionBorder(Graphics graphics) {
        ((Graphics2D)graphics).setStroke(GraphConstants.SELECTION_STROKE);
        if (this.childrenSelected) {
            graphics.setColor(this.graph.getGridColor());
        } else if (this.hasFocus && this.selected) {
            graphics.setColor(this.graph.getLockedHandleColor());
        } else if (this.selected) {
            graphics.setColor(this.graph.getHighlightColor());
        }
        if (this.childrenSelected || this.selected) {
            Dimension dimension = this.getSize();
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
    }

    public Point2D getPerimeterPoint(VertexView vertexView, Point2D point2D, Point2D point2D2) {
        Rectangle2D rectangle2D = vertexView.getBounds();
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        double d5 = d + d3 / 2.0;
        double d6 = d2 + d4 / 2.0;
        double d7 = point2D2.getX() - d5;
        double d8 = point2D2.getY() - d6;
        double d9 = Math.atan2(d8, d7);
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = Math.PI;
        double d13 = 1.5707963267948966;
        double d14 = d13 - d9;
        double d15 = Math.atan2(d4, d3);
        if (d9 < -d12 + d15 || d9 > d12 - d15) {
            d10 = d;
            d11 = d6 - d3 * Math.tan(d9) / 2.0;
        } else if (d9 < -d15) {
            d11 = d2;
            d10 = d5 - d4 * Math.tan(d14) / 2.0;
        } else if (d9 < d15) {
            d10 = d + d3;
            d11 = d6 + d3 * Math.tan(d9) / 2.0;
        } else {
            d11 = d2 + d4;
            d10 = d5 + d4 * Math.tan(d14) / 2.0;
        }
        return vertexView.getAttributes().createPoint(d10, d11);
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    public void repaint(Rectangle rectangle) {
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (string == "text") {
            super.firePropertyChange(string, object, object2);
        }
    }

    public void firePropertyChange(String string, byte by, byte by2) {
    }

    public void firePropertyChange(String string, char c, char c2) {
    }

    public void firePropertyChange(String string, short s, short s2) {
    }

    public void firePropertyChange(String string, int n, int n2) {
    }

    public void firePropertyChange(String string, long l, long l2) {
    }

    public void firePropertyChange(String string, float f, float f2) {
    }

    public void firePropertyChange(String string, double d, double d2) {
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    public boolean isHideGroups() {
        return this.hideGroups;
    }

    public void setHideGroups(boolean bl) {
        this.hideGroups = bl;
    }
}

