/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.layout;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.VertexView;
import org.jgraph.layout.JGraphLayoutSettings;

public abstract class JGraphLayoutAlgorithm {
    protected static Set LAYOUT_ATTRIBUTES = new HashSet();
    boolean isAllowedToRun = true;
    int progress = 0;
    int maximumProgress = 0;

    public JGraphLayoutSettings createSettings() {
        return null;
    }

    public String getHint() {
        return "";
    }

    public void run(JGraph jGraph, Object[] objectArray) {
        this.run(jGraph, objectArray, 0);
    }

    public abstract void run(JGraph var1, Object[] var2, int var3);

    public boolean isAllowedToRun() {
        return this.isAllowedToRun;
    }

    public void setAllowedToRun(boolean bl) {
        this.isAllowedToRun = bl;
    }

    public int getMaximumProgress() {
        return this.maximumProgress;
    }

    public void setMaximumProgress(int n) {
        this.maximumProgress = n;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int n) {
        this.progress = n;
    }

    public static JDialog createDialog(JGraphLayoutSettings jGraphLayoutSettings, JFrame jFrame, String string, String string2, String string3) {
        if (jGraphLayoutSettings instanceof Component) {
            return JGraphLayoutAlgorithm.populateDialog(jGraphLayoutSettings, new JDialog(jFrame, string, true), string2, string3);
        }
        return null;
    }

    public static JDialog createDialog(JGraphLayoutSettings jGraphLayoutSettings, JDialog jDialog, String string, String string2, String string3) {
        if (jGraphLayoutSettings instanceof Component) {
            return JGraphLayoutAlgorithm.populateDialog(jGraphLayoutSettings, new JDialog(jDialog, string, true), string2, string3);
        }
        return null;
    }

    public static JDialog populateDialog(final JGraphLayoutSettings jGraphLayoutSettings, final JDialog jDialog, String string, String string2) {
        if (jDialog != null && jGraphLayoutSettings instanceof Component) {
            jDialog.getContentPane().setLayout(new BorderLayout());
            jDialog.getContentPane().add((Component)((Object)jGraphLayoutSettings), "Center");
            JButton jButton = new JButton(string);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jDialog.dispose();
                }
            });
            JButton jButton2 = new JButton(string2);
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jGraphLayoutSettings.apply();
                    jDialog.dispose();
                }
            });
            JPanel jPanel = new JPanel(new FlowLayout(2));
            jPanel.add(jButton2);
            jPanel.add(jButton);
            jDialog.getContentPane().add((Component)jPanel, "South");
            jDialog.getRootPane().setDefaultButton(jButton2);
            return jDialog;
        }
        return jDialog;
    }

    public static void applyLayout(JGraph jGraph, Object[] objectArray, JGraphLayoutAlgorithm jGraphLayoutAlgorithm) {
        JGraph jGraph2 = new JGraph(jGraph.getModel());
        jGraph2.setBounds(jGraph.getBounds());
        GraphLayoutCache graphLayoutCache = jGraph2.getGraphLayoutCache();
        graphLayoutCache.setLocalAttributes(LAYOUT_ATTRIBUTES);
        jGraphLayoutAlgorithm.run(jGraph2, objectArray);
        if (jGraphLayoutAlgorithm.isAllowedToRun()) {
            Hashtable<Object, AttributeMap> hashtable = new Hashtable<Object, AttributeMap>();
            CellView[] cellViewArray = graphLayoutCache.getAllDescendants(graphLayoutCache.getRoots());
            int n = 0;
            while (n < cellViewArray.length) {
                AttributeMap attributeMap = cellViewArray[n].getAttributes();
                Rectangle2D rectangle2D = GraphConstants.getBounds((Map)attributeMap);
                if (cellViewArray[n] instanceof VertexView && rectangle2D == null) {
                    GraphConstants.setBounds((Map)attributeMap, (Rectangle2D)cellViewArray[n].getBounds());
                }
                if (!attributeMap.isEmpty()) {
                    hashtable.put(cellViewArray[n].getCell(), attributeMap);
                }
                ++n;
            }
            if (!hashtable.isEmpty()) {
                jGraph.getGraphLayoutCache().edit(hashtable, null, null, null);
            }
        }
    }

    static {
        LAYOUT_ATTRIBUTES.add("bounds");
        LAYOUT_ATTRIBUTES.add("points");
        LAYOUT_ATTRIBUTES.add("labelposition");
        LAYOUT_ATTRIBUTES.add("routing");
    }
}

