/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.layout;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.layout.JGraphLayoutAlgorithm;
import org.jgraph.layout.JGraphLayoutSettings;
import org.jgraph.layout.TreeLayoutSettings;

public class TreeLayoutAlgorithm
extends JGraphLayoutAlgorithm {
    protected int alignment = 1;
    protected int orientation = 1;
    protected int levelDistance = 30;
    protected int nodeDistance = 20;
    protected boolean centerRoot = true;
    protected boolean combineLevelNodes = true;
    private JGraph graph;
    private Map cell2node = new HashMap();

    public String toString() {
        return "Tree Layout";
    }

    public String getHint() {
        return "Select a root node";
    }

    public JGraphLayoutSettings createSettings() {
        return new TreeLayoutSettings(this);
    }

    public void setAlignment(int n) {
        if (n != 1 && n != 0 && n != 3) {
            throw new IllegalArgumentException("Alignment must be one of TOP, CENTER or BOTTOM");
        }
        this.alignment = n;
    }

    public void setOrientation(int n) {
        if (n != 1 && n != 3 && n != 5 && n != 7) {
            throw new IllegalArgumentException("Orientation must be one of NORTH, EAST, SOUTH or WEST");
        }
        this.orientation = n;
    }

    public void setLevelDistance(int n) {
        this.levelDistance = n;
    }

    public void setNodeDistance(int n) {
        this.nodeDistance = n;
    }

    public void setCenterRoot(boolean bl) {
        this.centerRoot = bl;
    }

    public void run(JGraph jGraph, Object[] objectArray, int n) {
        this.graph = jGraph;
        CellView[] cellViewArray = jGraph.getGraphLayoutCache().getMapping(new Object[]{objectArray[0]});
        List list = Arrays.asList(cellViewArray);
        Iterator<CellView> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof CellView) continue;
            iterator.remove();
        }
        list = this.buildTrees(list);
        this.layoutTrees(list);
        if (this.combineLevelNodes) {
            this.setLevelHeights(list);
        }
        this.setPosition(list);
    }

    private List buildTrees(List list) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(this.buildTree((CellView)iterator.next()));
        }
        return arrayList;
    }

    private TreeNode buildTree(CellView cellView) {
        List list = this.getChildren(cellView);
        TreeNode treeNode = this.getTreeNode(cellView);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CellView cellView2 = (CellView)iterator.next();
            TreeNode treeNode2 = this.buildTree(cellView2);
            treeNode.children.add(treeNode2);
        }
        return treeNode;
    }

    private List getChildren(CellView cellView) {
        ArrayList<CellView> arrayList = new ArrayList<CellView>();
        GraphModel graphModel = this.graph.getModel();
        Object object = cellView.getCell();
        int n = 0;
        while (n < graphModel.getChildCount(object)) {
            Object object2 = graphModel.getChild(object, n);
            Iterator iterator = graphModel.edges(object2);
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (object2 != graphModel.getSource(e)) continue;
                Object object3 = graphModel.getTarget(e);
                Object object4 = graphModel.getParent(object3);
                arrayList.add(this.graph.getGraphLayoutCache().getMapping(object4, false));
            }
            ++n;
        }
        return arrayList;
    }

    private TreeNode getTreeNode(CellView cellView) {
        Object v = this.cell2node.get(cellView);
        if (v != null) {
            return (TreeNode)v;
        }
        TreeNode treeNode = new TreeNode(cellView);
        this.cell2node.put(cellView, treeNode);
        return treeNode;
    }

    private void layoutTrees(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.layout((TreeNode)iterator.next());
        }
    }

    private void layout(TreeNode treeNode) {
        if (treeNode.children.size() != 0) {
            if (treeNode.children.size() == 1) {
                TreeNode treeNode2 = (TreeNode)treeNode.children.get(0);
                treeNode2.depth = treeNode.depth + 1;
                this.layout(treeNode2);
                treeNode2.leftContour.dx = (treeNode2.width - treeNode.width) / 2;
                treeNode2.rightContour.dx = (treeNode2.width - treeNode.width) / 2;
                treeNode.leftContour.next = treeNode2.leftContour;
                treeNode.rightContour.next = treeNode2.rightContour;
            } else {
                Iterator iterator = treeNode.children.iterator();
                while (iterator.hasNext()) {
                    TreeNode treeNode3 = (TreeNode)iterator.next();
                    treeNode3.depth = treeNode.depth + 1;
                    this.layout(treeNode3);
                }
                this.join(treeNode);
            }
        }
    }

    private void join(TreeNode treeNode) {
        int n = 0;
        int n2 = 0;
        while (n2 < treeNode.children.size()) {
            TreeNode treeNode2 = (TreeNode)treeNode.children.get(n2);
            int n3 = n2 + 1;
            while (n3 < treeNode.children.size()) {
                TreeNode treeNode3 = (TreeNode)treeNode.children.get(n3);
                int n4 = this.distance(treeNode2.rightContour, treeNode3.leftContour) / (n3 - n2);
                n = Math.max(n, n4);
                ++n3;
            }
            ++n2;
        }
        int n5 = treeNode.children.size() % 2 == 0 ? (treeNode.children.size() / 2 - 1) * n + n / 2 : treeNode.children.size() / 2 * (n += this.nodeDistance);
        Iterator iterator = treeNode.children.iterator();
        int n6 = 0;
        while (iterator.hasNext()) {
            ((TreeNode)iterator.next()).x = -n5 + n6 * n;
            ++n6;
        }
        TreeNode treeNode4 = (TreeNode)treeNode.children.get(0);
        TreeNode treeNode5 = (TreeNode)treeNode.children.get(treeNode.children.size() - 1);
        treeNode.leftContour.next = treeNode4.leftContour;
        treeNode.rightContour.next = treeNode5.leftContour;
        int n7 = 1;
        while (n7 < treeNode.children.size()) {
            TreeNode treeNode6 = (TreeNode)treeNode.children.get(n7);
            this.merge(treeNode.leftContour.next, treeNode6.leftContour, n7 * n + treeNode.width);
            ++n7;
        }
        int n8 = treeNode.children.size() - 2;
        while (n8 >= 0) {
            TreeNode treeNode7 = (TreeNode)treeNode.children.get(n8);
            this.merge(treeNode.rightContour.next, treeNode7.rightContour, n8 * n + treeNode.width);
            --n8;
        }
        n = (treeNode.children.size() - 1) * n / 2;
        treeNode.leftContour.next.dx += n - treeNode.width / 2;
        treeNode.rightContour.next.dx += n - treeNode.width / 2;
    }

    private void merge(PolyLine polyLine, PolyLine polyLine2, int n) {
        while (polyLine != null) {
            if (polyLine2.next == null) {
                return;
            }
            if (polyLine.next == null) {
                polyLine2 = polyLine2.next;
                break;
            }
            n += polyLine.dx - polyLine2.dx;
            polyLine = polyLine.next;
            polyLine2 = polyLine2.next;
        }
        polyLine2.dx += -n;
        polyLine.next = polyLine2;
    }

    private int distance(PolyLine polyLine, PolyLine polyLine2) {
        int n = 0;
        int n2 = 0;
        while (polyLine != null && polyLine2 != null) {
            if ((n2 += polyLine.dx + polyLine2.dx) > 0) {
                n += n2;
                n2 = 0;
            }
            polyLine = polyLine.next;
            polyLine2 = polyLine2.next;
        }
        return n;
    }

    private void setPosition(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((TreeNode)iterator.next()).setPosition(null, 0);
        }
    }

    private void setLevelHeights(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            List list2 = ((TreeNode)iterator.next()).getNodesByLevel();
            int n = 0;
            int n2 = 0;
            while (n2 < list2.size()) {
                List list3 = (List)list2.get(n2);
                int n3 = 0;
                while (n3 < list3.size()) {
                    n = Math.max(n, ((TreeNode)list3.get((int)n3)).height);
                    ++n3;
                }
                int n4 = 0;
                while (n4 < list3.size()) {
                    ((TreeNode)list3.get((int)n4)).levelheight = n;
                    ++n4;
                }
                n = 0;
                ++n2;
            }
        }
    }

    public boolean isCombineLevelNodes() {
        return this.combineLevelNodes;
    }

    public void setCombineLevelNodes(boolean bl) {
        this.combineLevelNodes = bl;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public boolean isCenterRoot() {
        return this.centerRoot;
    }

    public int getLevelDistance() {
        return this.levelDistance;
    }

    public int getNodeDistance() {
        return this.nodeDistance;
    }

    public int getOrientation() {
        return this.orientation;
    }

    private class PolyLine {
        int dx;
        PolyLine next;

        public PolyLine(int n) {
            this.dx = n;
        }
    }

    private class TreeNode {
        List children;
        int width;
        int height;
        int x;
        int y;
        int levelheight;
        PolyLine leftContour;
        PolyLine rightContour;
        int depth;
        CellView view;

        public TreeNode(CellView cellView) {
            this.view = cellView;
            if (TreeLayoutAlgorithm.this.orientation == 1 || TreeLayoutAlgorithm.this.orientation == 5) {
                this.width = (int)cellView.getBounds().getWidth();
                this.height = (int)cellView.getBounds().getHeight();
            } else {
                this.width = (int)cellView.getBounds().getHeight();
                this.height = (int)cellView.getBounds().getWidth();
            }
            this.children = new ArrayList();
            this.leftContour = new PolyLine(this.width / 2);
            this.rightContour = new PolyLine(this.width / 2);
            this.depth = 0;
        }

        public Iterator getChildren() {
            return this.children.iterator();
        }

        public int getLeftWidth() {
            int n = 0;
            PolyLine polyLine = this.leftContour;
            int n2 = 0;
            while (polyLine != null) {
                if ((n2 += polyLine.dx) > 0) {
                    n += n2;
                    n2 = 0;
                }
                polyLine = polyLine.next;
            }
            return n;
        }

        public int getRightWidth() {
            int n = 0;
            PolyLine polyLine = this.rightContour;
            int n2 = 0;
            while (polyLine != null) {
                if ((n2 += polyLine.dx) > 0) {
                    n += n2;
                    n2 = 0;
                }
                polyLine = polyLine.next;
            }
            return n;
        }

        public int getHeight() {
            if (this.children.isEmpty()) {
                return this.levelheight;
            }
            int n = 0;
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                n = Math.max(n, ((TreeNode)iterator.next()).getHeight());
            }
            return n + TreeLayoutAlgorithm.this.levelDistance + this.levelheight;
        }

        public void setPosition(Point point, int n) {
            int n2 = 0;
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                n2 = Math.max(n2, ((TreeNode)iterator.next()).height);
            }
            if (point == null) {
                int n3;
                Rectangle2D rectangle2D = this.view.getBounds();
                Rectangle rectangle = new Rectangle((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
                Point point2 = rectangle.getLocation();
                if (TreeLayoutAlgorithm.this.centerRoot) {
                    n3 = this.getLeftWidth();
                    int n4 = this.getRightWidth();
                    int n5 = this.getHeight();
                    Insets insets = TreeLayoutAlgorithm.this.graph.getInsets();
                    if (TreeLayoutAlgorithm.this.orientation == 1) {
                        rectangle.x = n3 - this.width / 2;
                        rectangle.y = insets.top;
                    } else if (TreeLayoutAlgorithm.this.orientation == 3) {
                        rectangle.x = insets.left + n5 - this.width;
                        rectangle.y = n3 - this.height / 2;
                    } else if (TreeLayoutAlgorithm.this.orientation == 5) {
                        rectangle.x = n3 - this.width / 2;
                        rectangle.y = insets.top + n5;
                    } else if (TreeLayoutAlgorithm.this.orientation == 7) {
                        rectangle.x = insets.right;
                        rectangle.y = n3 - this.width / 2;
                    }
                    Object object = this.view.getCell();
                    Map map = GraphConstants.createAttributes((Object)object, (Object)"bounds", (Object)rectangle);
                    TreeLayoutAlgorithm.this.graph.getGraphLayoutCache().edit(map, null, null, null);
                    if (TreeLayoutAlgorithm.this.orientation == 7 || TreeLayoutAlgorithm.this.orientation == 3) {
                        TreeLayoutAlgorithm.this.graph.setPreferredSize(new Dimension(n5 + insets.left + insets.right, n3 + n4 + insets.top + insets.bottom));
                    } else {
                        TreeLayoutAlgorithm.this.graph.setPreferredSize(new Dimension(n3 + n4 + insets.left + insets.right, n5 + insets.top + insets.bottom));
                    }
                    point2 = rectangle.getLocation();
                }
                if (TreeLayoutAlgorithm.this.orientation == 7 || TreeLayoutAlgorithm.this.orientation == 3) {
                    n3 = point2.x;
                    point2.x = point2.y;
                    point2.y = n3;
                }
                if (TreeLayoutAlgorithm.this.orientation == 1 || TreeLayoutAlgorithm.this.orientation == 7) {
                    point = new Point(point2.x + this.width / 2, point2.y + this.height);
                } else if (TreeLayoutAlgorithm.this.orientation == 5 || TreeLayoutAlgorithm.this.orientation == 3) {
                    point = new Point(point2.x + this.width / 2, point2.y);
                }
                Iterator iterator2 = this.children.iterator();
                while (iterator2.hasNext()) {
                    ((TreeNode)iterator2.next()).setPosition(point, n2);
                }
                return;
            }
            if (TreeLayoutAlgorithm.this.combineLevelNodes) {
                n = this.levelheight;
            }
            Rectangle rectangle = new Rectangle(this.width, this.height);
            if (TreeLayoutAlgorithm.this.orientation == 1 || TreeLayoutAlgorithm.this.orientation == 7) {
                rectangle.x = this.x + point.x - this.width / 2;
                rectangle.y = point.y + TreeLayoutAlgorithm.this.levelDistance;
            } else {
                rectangle.x = this.x + point.x - this.width / 2;
                rectangle.y = point.y - TreeLayoutAlgorithm.this.levelDistance - this.levelheight;
            }
            if (TreeLayoutAlgorithm.this.alignment == 0) {
                rectangle.y += (n - this.height) / 2;
            } else if (TreeLayoutAlgorithm.this.alignment == 3) {
                rectangle.y += n - this.height;
            }
            if (TreeLayoutAlgorithm.this.orientation == 7 || TreeLayoutAlgorithm.this.orientation == 3) {
                int n6 = rectangle.x;
                rectangle.x = rectangle.y;
                rectangle.y = n6;
                n6 = rectangle.width;
                rectangle.width = rectangle.height;
                rectangle.height = n6;
            }
            Object object = this.view.getCell();
            Map map = GraphConstants.createAttributes((Object)object, (Object)"bounds", (Object)rectangle);
            TreeLayoutAlgorithm.this.graph.getGraphLayoutCache().edit(map, null, null, null);
            this.y = TreeLayoutAlgorithm.this.orientation == 1 || TreeLayoutAlgorithm.this.orientation == 7 ? point.y + TreeLayoutAlgorithm.this.levelDistance + n : point.y - TreeLayoutAlgorithm.this.levelDistance - n;
            Iterator iterator3 = this.children.iterator();
            while (iterator3.hasNext()) {
                ((TreeNode)iterator3.next()).setPosition(new Point(this.x + point.x, this.y), n2);
            }
        }

        public List getNodesByLevel() {
            List list;
            List list2 = new ArrayList();
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                list = ((TreeNode)iterator.next()).getNodesByLevel();
                if (list2.size() < list.size()) {
                    ArrayList arrayList = list2;
                    list2 = list;
                    list = arrayList;
                }
                int n = 0;
                while (n < list.size()) {
                    ((List)list2.get(n)).addAll((List)list.get(n));
                    ++n;
                }
            }
            list = new ArrayList<TreeNode>();
            ((ArrayList)list).add(this);
            list2.add(0, list);
            return list2;
        }
    }
}

