/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.util;

import java.awt.Color;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.util.JGraphUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JGraphGXLCodec {
    static transient Hashtable hash;

    public static String encode(JGraph jGraph, Object[] objectArray) {
        hash = new Hashtable();
        String string = "<gxl><graph>";
        int n = 0;
        while (n < objectArray.length) {
            if (JGraphUtilities.isVertex(jGraph, objectArray[n])) {
                hash.put(objectArray[n], new Integer(hash.size()));
            }
            ++n;
        }
        Iterator iterator = hash.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            string = string + JGraphGXLCodec.encodeVertex(jGraph, hash.get(k), k);
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < objectArray.length) {
            if (jGraph.getModel().isEdge(objectArray[n3])) {
                string = string + JGraphGXLCodec.encodeEdge(jGraph, new Integer(n2++), objectArray[n3]);
            }
            ++n3;
        }
        string = string + "\n</graph></gxl>";
        return string;
    }

    public static String encodeVertex(JGraph jGraph, Object object, Object object2) {
        String string = jGraph.convertValueToString(object2);
        return "\n\t<node id=\"node" + object.toString() + "\">" + "\n\t\t<attr name=\"Label\">" + "\n\t\t\t<string>" + string + "</string>" + "\n\t\t</attr>" + "\n\t</node>";
    }

    public static String encodeEdge(JGraph jGraph, Object object, Object object2) {
        Object object3;
        String string;
        GraphModel graphModel = jGraph.getModel();
        String string2 = "";
        if (graphModel.getSource(object2) != null && (string = hash.get(graphModel.getParent(graphModel.getSource(object2)))) != null) {
            string2 = "node" + string.toString();
        }
        string = "";
        if (graphModel.getTarget(object2) != null && (object3 = hash.get(graphModel.getParent(graphModel.getTarget(object2)))) != null) {
            string = "node" + object3.toString();
        }
        if (string2 != null && string != null) {
            object3 = jGraph.convertValueToString(object2);
            return "\n\t<edge id=\"edge" + object.toString() + "\"" + " from=\"" + string2 + "\"" + " to=\"" + string + "\">" + "\n\t\t<attr name=\"Label\">" + "\n\t\t\t<string>" + (String)object3 + "</string>" + "\n\t\t</attr>" + "\n\t</edge>";
        }
        return "";
    }

    protected static void decodeCell(Node node, Map map) {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (node2.getNodeName().equals("view")) {
                Element element = (Element)node2;
                if (element.getAttribute("font-name") != null) {
                    // empty if block
                }
                if (element.getAttribute("font-size") != null) {
                    // empty if block
                }
                if (element.getAttribute("font-style") != null) {
                    String string = element.getAttribute("font-style");
                    if (string.equals("plain")) {
                        // empty if block
                    }
                    if (string.indexOf("italic") != -1) {
                        // empty if block
                    }
                    if (string.indexOf("bold") != -1) {
                        // empty if block
                    }
                }
                if (element.getAttribute("color") != null) {
                    try {
                        int n2 = Integer.parseInt(element.getAttribute("color"));
                        GraphConstants.setForeground((Map)map, (Color)new Color(n2));
                        GraphConstants.setBorderColor((Map)map, (Color)new Color(n2));
                        GraphConstants.setLineColor((Map)map, (Color)new Color(n2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (element.getAttribute("background-color") != null) {
                    try {
                        int n3 = Integer.parseInt(element.getAttribute("background-color"));
                        GraphConstants.setBackground((Map)map, (Color)new Color(n3));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (element.getAttribute("auto-size") != null) {
                    GraphConstants.setAutoSize((Map)map, (boolean)"true".equals(element.getAttribute("auto-size")));
                }
            }
            ++n;
        }
    }

    protected static void decodeEdge(Node node, Map map) {
        JGraphGXLCodec.decodeCell(node, map);
    }

    public static void decode(InputStream inputStream, JGraph jGraph) throws Exception {
        String string = null;
        GraphModel graphModel = jGraph.getModel();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputStream);
        ArrayList<String> arrayList = new ArrayList<String>();
        ConnectionSet connectionSet = new ConnectionSet();
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        if (nodeList.getLength() == 0) {
            return;
        }
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeName().equals("graph")) {
                Element element2 = (Element)node;
                NodeList nodeList2 = element2.getChildNodes();
                boolean bl = "directed".equals(element2.getAttribute("edgemode")) || "defaultdirected".equals(element2.getAttribute("edgemode"));
                int n2 = 0;
                while (n2 < nodeList2.getLength()) {
                    Node node2 = nodeList2.item(n2);
                    String string2 = JGraphGXLCodec.getLabel(node2);
                    if (node2.getAttributes() != null && node2.getNodeName() != null) {
                        Object object;
                        String string3;
                        Node node3;
                        Object object2;
                        String string4 = node2.getNodeName().toString().toLowerCase();
                        if (string4.equals("node")) {
                            object2 = null;
                            node3 = node2.getAttributes().getNamedItem("id");
                            if (node3 != null) {
                                object2 = node3.getNodeValue();
                            }
                            if (object2 != null && !hashtable.keySet().contains(object2)) {
                                string3 = new DefaultGraphCell((Object)string2);
                                string3.add((MutableTreeNode)new DefaultPort());
                                hashtable.put(object2, string3);
                                object = JGraphGXLCodec.createDefaultAttributes(jGraph.getModel().createAttributes());
                                JGraphGXLCodec.decodeCell(node2, (Map)object);
                                hashtable2.put(string3, object);
                                arrayList.add(string3);
                            }
                        } else if (string4.equals("edge")) {
                            DefaultGraphCell defaultGraphCell;
                            object2 = (Element)node2;
                            node3 = node2.getAttributes().getNamedItem("from");
                            string3 = null;
                            if (node3 != null) {
                                string3 = node3.getNodeValue();
                            }
                            node3 = node2.getAttributes().getNamedItem("to");
                            object = null;
                            if (node3 != null) {
                                object = node3.getNodeValue();
                            }
                            DefaultEdge defaultEdge = new DefaultEdge((Object)string2);
                            if (string3 != null && (defaultGraphCell = (DefaultGraphCell)hashtable.get(string3)) != null) {
                                connectionSet.connect((Object)defaultEdge, (Object)defaultGraphCell.getChildAt(0), true);
                            }
                            if (object != null && (defaultGraphCell = (DefaultGraphCell)hashtable.get(object)) != null) {
                                connectionSet.connect((Object)defaultEdge, (Object)defaultGraphCell.getChildAt(0), false);
                            }
                            boolean bl2 = ("true".equals(object2.getAttribute("isdirected")) || bl) && !"false".equals(object2.getAttribute("isdirected"));
                            AttributeMap attributeMap = jGraph.getModel().createAttributes();
                            if (bl2) {
                                GraphConstants.setLineEnd((Map)attributeMap, (int)1);
                                GraphConstants.setEndFill((Map)attributeMap, (boolean)true);
                            }
                            JGraphGXLCodec.decodeEdge((Node)object2, (Map)attributeMap);
                            hashtable2.put((String)defaultEdge, attributeMap);
                            arrayList.add((String)defaultEdge);
                        } else if (string4.equals("view")) {
                            string = ((Element)node2).getAttribute("defaultlayout");
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        graphModel.insert(arrayList.toArray(), hashtable2, connectionSet, null, null);
    }

    public static Map createDefaultAttributes(AttributeMap attributeMap) {
        GraphConstants.setBorderColor((Map)attributeMap, (Color)Color.black);
        return attributeMap;
    }

    protected static String getLabel(Node node) {
        String string = null;
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node2 = nodeList.item(n);
            if (node2.getNodeName().equals("attr") && node2.getAttributes().getNamedItem("name").getNodeValue().equals("Label")) {
                NodeList nodeList2 = node2.getChildNodes();
                int n2 = 0;
                while (n2 < nodeList2.getLength()) {
                    Node node3;
                    if (nodeList2.item(n2).getNodeName().equals("string") && (node3 = nodeList2.item(n2).getFirstChild()) != null) {
                        string = node3.getNodeValue();
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return string != null ? string : new String("");
    }
}

