/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.util;

import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import org.jgraph.JGraph;
import org.jgraph.graph.GraphModel;
import org.jgraph.util.JGraphUtilities;

public class JGraphGraphvizEncoder {
    static transient Hashtable hash;

    public static String encode(JGraph jGraph, Object[] objectArray) {
        hash = new Hashtable();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1);
        String string = dateFormat.format(new Date());
        StringBuffer stringBuffer = new StringBuffer("/* Graphviz file generated by JGraph - " + string + " */" + "\n\ndigraph G {");
        int n = 0;
        while (n < objectArray.length) {
            if (JGraphUtilities.isVertex(jGraph, objectArray[n])) {
                hash.put(objectArray[n], new Integer(hash.size()));
            }
            ++n;
        }
        Iterator iterator = hash.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            stringBuffer.append(JGraphGraphvizEncoder.encodeVertex(jGraph, hash.get(k), k));
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < objectArray.length) {
            if (jGraph.getModel().isEdge(objectArray[n3])) {
                stringBuffer.append(JGraphGraphvizEncoder.encodeEdge(jGraph, new Integer(n2++), objectArray[n3]));
            }
            ++n3;
        }
        stringBuffer.append("\n}");
        return stringBuffer.toString();
    }

    private static String encodeVertex(JGraph jGraph, Object object, Object object2) {
        if (object == null) {
            return "";
        }
        String string = jGraph.convertValueToString(object2);
        if (string == null) {
            string = "";
        }
        return "\n\t" + object.toString() + " [label=\"" + string + "\", " + "shape=\"box\"];";
    }

    private static String encodeEdge(JGraph jGraph, Object object, Object object2) {
        GraphModel graphModel = jGraph.getModel();
        String string = null;
        Object object3 = graphModel.getSource(object2);
        if (object3 != null) {
            Object v;
            Object v2 = hash.get(graphModel.getParent(object3));
            if (v2 != null) {
                string = v2.toString();
            }
            String string2 = null;
            Object object4 = graphModel.getTarget(object2);
            if (object4 != null && (v = hash.get(graphModel.getParent(object4))) != null) {
                string2 = v.toString();
            }
            if (string != null && string2 != null) {
                return "\n\t" + string + " -> " + string2 + ";";
            }
        }
        return "";
    }
}

