/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.io.CharArrayBuffer;
import org.apache.http.io.SecureSocketFactory;
import org.apache.http.io.SocketFactory;
import org.apache.http.util.LangUtils;

public class Scheme {
    private static final Map SCHEMES = Collections.synchronizedMap(new HashMap());
    private String name;
    private SocketFactory socketFactory;
    private int defaultPort;
    private boolean secure;

    public static void registerScheme(String id, Scheme scheme) {
        if (id == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        if (scheme == null) {
            throw new IllegalArgumentException("Scheme may not be null");
        }
        SCHEMES.put(id, scheme);
    }

    public static void unregisterScheme(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        SCHEMES.remove(id);
    }

    public static Scheme getScheme(String id) throws IllegalStateException {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        Scheme scheme = (Scheme)SCHEMES.get(id);
        if (scheme == null) {
            throw new IllegalStateException("Unsupported scheme: '" + id + "'");
        }
        return scheme;
    }

    public Scheme(String name, SocketFactory factory, int defaultPort) {
        if (name == null) {
            throw new IllegalArgumentException("Scheme name may not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Socket factory may not be null");
        }
        if (defaultPort <= 0) {
            throw new IllegalArgumentException("Port is invalid: " + defaultPort);
        }
        this.name = name;
        this.socketFactory = factory;
        this.defaultPort = defaultPort;
        this.secure = factory instanceof SecureSocketFactory;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public int resolvePort(int port) {
        return port <= 0 ? this.getDefaultPort() : port;
    }

    public String toString() {
        CharArrayBuffer buffer = new CharArrayBuffer(32);
        buffer.append(this.name);
        buffer.append(':');
        buffer.append(Integer.toString(this.defaultPort));
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Scheme) {
            Scheme p = (Scheme)obj;
            return this.defaultPort == p.getDefaultPort() && this.name.equalsIgnoreCase(p.getName()) && this.secure == p.isSecure() && this.socketFactory.equals(p.getSocketFactory());
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = LangUtils.hashCode(hash, this.defaultPort);
        hash = LangUtils.hashCode(hash, this.name.toLowerCase());
        hash = LangUtils.hashCode(hash, this.secure);
        hash = LangUtils.hashCode(hash, this.socketFactory);
        return hash;
    }
}

