/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl;

import java.io.IOException;
import java.net.Socket;
import org.apache.http.ConnectionClosedException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestFactory;
import org.apache.http.HttpResponse;
import org.apache.http.HttpServerConnection;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.apache.http.entity.EntityDeserializer;
import org.apache.http.entity.EntitySerializer;
import org.apache.http.impl.AbstractHttpConnection;
import org.apache.http.impl.DefaultHttpRequestFactory;
import org.apache.http.impl.entity.DefaultEntityDeserializer;
import org.apache.http.impl.entity.DefaultEntitySerializer;
import org.apache.http.io.CharArrayBuffer;
import org.apache.http.params.HttpParams;
import org.apache.http.util.HeaderUtils;

public class DefaultHttpServerConnection
extends AbstractHttpConnection
implements HttpServerConnection {
    private int maxHeaderCount = -1;
    private final CharArrayBuffer buffer;
    private HttpRequestFactory requestfactory = new DefaultHttpRequestFactory();
    private EntitySerializer entityserializer = null;
    private EntityDeserializer entitydeserializer = null;

    public DefaultHttpServerConnection() {
        this.buffer = new CharArrayBuffer(128);
        this.entityserializer = new DefaultEntitySerializer();
        this.entitydeserializer = new DefaultEntityDeserializer();
    }

    public void setRequestFactory(HttpRequestFactory requestfactory) {
        if (requestfactory == null) {
            throw new IllegalArgumentException("Factory may not be null");
        }
        this.requestfactory = requestfactory;
    }

    public void setEntityDeserializer(EntityDeserializer entitydeserializer) {
        if (entitydeserializer == null) {
            throw new IllegalArgumentException("Entity deserializer may not be null");
        }
        this.entitydeserializer = entitydeserializer;
    }

    public void setEntitySerializer(EntitySerializer entityserializer) {
        if (entityserializer == null) {
            throw new IllegalArgumentException("Entity serializer may not be null");
        }
        this.entityserializer = entityserializer;
    }

    public void bind(Socket socket, HttpParams params) throws IOException {
        super.bind(socket, params);
        this.maxHeaderCount = params.getIntParameter("http.connection.max-header-count", -1);
    }

    public HttpRequest receiveRequestHeader(HttpParams params) throws HttpException, IOException {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.assertOpen();
        HttpRequest request = this.receiveRequestLine(params);
        this.receiveRequestHeaders(request);
        return request;
    }

    public void receiveRequestEntity(HttpEntityEnclosingRequest request) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        this.assertOpen();
        HttpEntity entity = this.entitydeserializer.deserialize(this.datareceiver, request);
        request.setEntity(entity);
    }

    protected HttpRequest receiveRequestLine(HttpParams params) throws HttpException, IOException {
        this.buffer.clear();
        int i = this.datareceiver.readLine(this.buffer);
        if (i == -1) {
            throw new ConnectionClosedException("Client closed connection");
        }
        RequestLine requestline = RequestLine.parse(this.buffer, 0, this.buffer.length());
        HttpRequest request = this.requestfactory.newHttpRequest(requestline);
        request.getParams().setDefaults(params);
        return request;
    }

    protected void receiveRequestHeaders(HttpRequest request) throws HttpException, IOException {
        Header[] headers = HeaderUtils.parseHeaders(this.datareceiver, this.maxHeaderCount);
        for (int i = 0; i < headers.length; ++i) {
            request.addHeader(headers[i]);
        }
    }

    public void flush() throws IOException {
        this.assertOpen();
        this.datatransmitter.flush();
    }

    public void sendResponseHeader(HttpResponse response) throws HttpException, IOException {
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        this.assertOpen();
        this.sendResponseStatusLine(response);
        this.sendResponseHeaders(response);
    }

    public void sendResponseEntity(HttpResponse response) throws HttpException, IOException {
        if (response.getEntity() == null) {
            return;
        }
        this.entityserializer.serialize(this.datatransmitter, response, response.getEntity());
    }

    protected void sendResponseStatusLine(HttpResponse response) throws HttpException, IOException {
        this.buffer.clear();
        StatusLine.format(this.buffer, response.getStatusLine());
        this.datatransmitter.writeLine(this.buffer);
    }

    protected void sendResponseHeaders(HttpResponse response) throws HttpException, IOException {
        Header[] headers = response.getAllHeaders();
        for (int i = 0; i < headers.length; ++i) {
            this.buffer.clear();
            Header.format(this.buffer, headers[i]);
            this.datatransmitter.writeLine(this.buffer);
        }
        this.buffer.clear();
        this.datatransmitter.writeLine(this.buffer);
    }
}

