/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.http.ConnectTimeoutException;
import org.apache.http.io.SecureSocketFactory;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class SSLSocketFactory
implements SecureSocketFactory {
    private static final SSLSocketFactory DEFAULT_FACTORY = new SSLSocketFactory();

    public static SSLSocketFactory getSocketFactory() {
        return DEFAULT_FACTORY;
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = HttpConnectionParams.getConnectionTimeout(params);
        if (timeout != 0) {
            throw new IllegalStateException("Connection timeout is not supported in old IO mode");
        }
        javax.net.ssl.SSLSocketFactory socketfactory = (javax.net.ssl.SSLSocketFactory)javax.net.ssl.SSLSocketFactory.getDefault();
        if (localAddress != null) {
            return socketfactory.createSocket(host, port, localAddress, localPort);
        }
        return socketfactory.createSocket(host, port);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        javax.net.ssl.SSLSocketFactory socketfactory = (javax.net.ssl.SSLSocketFactory)javax.net.ssl.SSLSocketFactory.getDefault();
        return socketfactory.createSocket(socket, host, port, autoClose);
    }
}

