/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.util;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpException;
import org.apache.http.ProtocolException;
import org.apache.http.io.CharArrayBuffer;
import org.apache.http.io.HttpDataReceiver;

public class HeaderUtils {
    private HeaderUtils() {
    }

    public static Header[] parseHeaders(HttpDataReceiver datareceiver, int maxCount) throws HttpException, IOException {
        int i;
        ArrayList<CharArrayBuffer> headerLines;
        block9: {
            if (datareceiver == null) {
                throw new IllegalArgumentException("HTTP data receiver may not be null");
            }
            headerLines = new ArrayList<CharArrayBuffer>();
            CharArrayBuffer current = null;
            CharArrayBuffer previous = null;
            do {
                if (current == null) {
                    current = new CharArrayBuffer(64);
                } else {
                    current.clear();
                }
                int l = datareceiver.readLine(current);
                if (l == -1 || current.length() < 1) break block9;
                if ((current.charAt(0) == ' ' || current.charAt(0) == '\t') && previous != null) {
                    char ch;
                    for (i = 0; i < current.length() && ((ch = current.charAt(i)) == ' ' || ch == '\t'); ++i) {
                    }
                    previous.append(' ');
                    previous.append(current, i, current.length() - i);
                    continue;
                }
                headerLines.add(current);
                previous = current;
                current = null;
            } while (maxCount <= 0 || headerLines.size() < maxCount);
            throw new IOException("Maximum header count exceeded");
        }
        Header[] headers = new Header[headerLines.size()];
        for (i = 0; i < headerLines.size(); ++i) {
            CharArrayBuffer buffer = (CharArrayBuffer)headerLines.get(i);
            int colon = buffer.indexOf(58);
            if (colon == -1) {
                throw new ProtocolException("Invalid header: " + buffer.toString());
            }
            String s = buffer.substringTrimmed(0, colon);
            if (s.equals("")) {
                throw new ProtocolException("Invalid header: " + buffer.toString());
            }
            headers[i] = new BufferedHeader(s, buffer, colon + 1);
        }
        return headers;
    }

    public static Header[] parseHeaders(HttpDataReceiver datareceiver) throws HttpException, IOException {
        return HeaderUtils.parseHeaders(datareceiver, -1);
    }

    static class BufferedHeader
    extends Header {
        private final CharArrayBuffer buffer;
        private final int posValue;

        public BufferedHeader(String name, CharArrayBuffer buffer, int posValue) {
            super(name, null);
            this.buffer = buffer;
            this.posValue = posValue;
        }

        public String getValue() {
            return this.buffer.substringTrimmed(this.posValue, this.buffer.length());
        }

        public HeaderElement[] getElements() {
            return HeaderElement.parseAll(this.buffer, this.posValue, this.buffer.length());
        }

        public String toString() {
            return this.buffer.toString();
        }
    }
}

