/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.rules.ZeroR;
import weka.core.Attribute;
import weka.core.AttributeStats;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.UnsupportedClassTypeException;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.MakeIndicator;
import weka.filters.unsupervised.instance.RemoveWithValues;

public class MultiClassClassifier
extends Classifier
implements OptionHandler {
    private Classifier[] m_Classifiers;
    private Filter[] m_ClassFilters;
    private Classifier m_Classifier = new ZeroR();
    private ZeroR m_ZeroR;
    private Attribute m_ClassAttribute;
    private Instances m_TwoClassDataset;
    protected int m_Seed = 1;
    private double m_RandomWidthFactor = 2.0;
    private int m_Method = 0;
    public static final int METHOD_1_AGAINST_ALL = 0;
    public static final int METHOD_ERROR_RANDOM = 1;
    public static final int METHOD_ERROR_EXHAUSTIVE = 2;
    public static final int METHOD_1_AGAINST_1 = 3;
    public static final Tag[] TAGS_METHOD = new Tag[]{new Tag(0, "1-against-all"), new Tag(1, "Random correction code"), new Tag(2, "Exhaustive correction code"), new Tag(3, "1-against-1")};

    public void buildClassifier(Instances instances) throws Exception {
        if (!instances.classAttribute().isNominal()) {
            throw new UnsupportedClassTypeException("MultiClassClassifier: class should be nominal!");
        }
        if (this.m_Classifier == null) {
            throw new Exception("No base classifier has been set!");
        }
        this.m_ZeroR = new ZeroR();
        this.m_ZeroR.buildClassifier(instances);
        this.m_TwoClassDataset = null;
        int n = instances.numClasses();
        if (n <= 2) {
            this.m_Classifiers = Classifier.makeCopies(this.m_Classifier, 1);
            this.m_Classifiers[0].buildClassifier(instances);
            this.m_ClassFilters = null;
        } else if (this.m_Method == 3) {
            int[] nArray;
            int n2;
            FastVector fastVector = new FastVector();
            for (n2 = 0; n2 < instances.numClasses(); ++n2) {
                for (int i = 0; i < instances.numClasses(); ++i) {
                    if (i <= n2) continue;
                    nArray = new int[]{n2, i};
                    fastVector.addElement(nArray);
                }
            }
            n = fastVector.size();
            this.m_Classifiers = Classifier.makeCopies(this.m_Classifier, n);
            this.m_ClassFilters = new Filter[n];
            for (n2 = 0; n2 < n; ++n2) {
                RemoveWithValues removeWithValues = new RemoveWithValues();
                removeWithValues.setAttributeIndex("" + (instances.classIndex() + 1));
                removeWithValues.setModifyHeader(true);
                removeWithValues.setInvertSelection(true);
                removeWithValues.setNominalIndicesArr((int[])fastVector.elementAt(n2));
                nArray = (int[])fastVector.elementAt(n2);
                Instances instances2 = new Instances(instances, 0);
                instances2.setClassIndex(-1);
                removeWithValues.setInputFormat(instances2);
                Instances instances3 = Filter.useFilter(instances, removeWithValues);
                if (instances3.numInstances() > 0) {
                    instances3.setClassIndex(instances.classIndex());
                    this.m_Classifiers[n2].buildClassifier(instances3);
                    this.m_ClassFilters[n2] = removeWithValues;
                    continue;
                }
                this.m_Classifiers[n2] = null;
                this.m_ClassFilters[n2] = null;
            }
            this.m_TwoClassDataset = new Instances(instances, 0);
            n2 = this.m_TwoClassDataset.classIndex();
            this.m_TwoClassDataset.setClassIndex(-1);
            this.m_TwoClassDataset.deleteAttributeAt(n2);
            FastVector fastVector2 = new FastVector();
            fastVector2.addElement("class0");
            fastVector2.addElement("class1");
            this.m_TwoClassDataset.insertAttributeAt(new Attribute("class", fastVector2), n2);
            this.m_TwoClassDataset.setClassIndex(n2);
        } else {
            Code code = null;
            switch (this.m_Method) {
                case 2: {
                    code = new ExhaustiveCode(n);
                    break;
                }
                case 1: {
                    code = new RandomCode(n, (int)((double)n * this.m_RandomWidthFactor), instances);
                    break;
                }
                case 0: {
                    code = new StandardCode(n);
                    break;
                }
                default: {
                    throw new Exception("Unrecognized correction code type");
                }
            }
            n = code.size();
            this.m_Classifiers = Classifier.makeCopies(this.m_Classifier, n);
            this.m_ClassFilters = new MakeIndicator[n];
            AttributeStats attributeStats = instances.attributeStats(instances.classIndex());
            for (int i = 0; i < this.m_Classifiers.length; ++i) {
                this.m_ClassFilters[i] = new MakeIndicator();
                MakeIndicator makeIndicator = (MakeIndicator)this.m_ClassFilters[i];
                makeIndicator.setAttributeIndex("" + (instances.classIndex() + 1));
                makeIndicator.setValueIndices(code.getIndices(i));
                makeIndicator.setNumeric(false);
                makeIndicator.setInputFormat(instances);
                Instances instances4 = Filter.useFilter(instances, this.m_ClassFilters[i]);
                this.m_Classifiers[i].buildClassifier(instances4);
            }
        }
        this.m_ClassAttribute = instances.classAttribute();
    }

    public double[] individualPredictions(Instance instance) throws Exception {
        double[] dArray = null;
        if (this.m_Classifiers.length == 1) {
            dArray = new double[]{this.m_Classifiers[0].distributionForInstance(instance)[1]};
        } else {
            dArray = new double[this.m_ClassFilters.length];
            for (int i = 0; i < this.m_ClassFilters.length; ++i) {
                if (this.m_Classifiers[i] == null) continue;
                if (this.m_Method == 3) {
                    Instance instance2 = new Instance(instance);
                    instance2.setDataset(this.m_TwoClassDataset);
                    dArray[i] = this.m_Classifiers[i].distributionForInstance(instance2)[1];
                    continue;
                }
                this.m_ClassFilters[i].input(instance);
                this.m_ClassFilters[i].batchFinished();
                dArray[i] = this.m_Classifiers[i].distributionForInstance(this.m_ClassFilters[i].output())[1];
            }
        }
        return dArray;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_Classifiers.length == 1) {
            return this.m_Classifiers[0].distributionForInstance(instance);
        }
        double[] dArray = new double[instance.numClasses()];
        if (this.m_Method == 3) {
            for (int i = 0; i < this.m_ClassFilters.length; ++i) {
                if (this.m_Classifiers[i] == null) continue;
                Instance instance2 = new Instance(instance);
                instance2.setDataset(this.m_TwoClassDataset);
                double[] dArray2 = this.m_Classifiers[i].distributionForInstance(instance2);
                Range range = new Range(((RemoveWithValues)this.m_ClassFilters[i]).getNominalIndices());
                range.setUpper(this.m_ClassAttribute.numValues());
                int[] nArray = range.getSelection();
                if (dArray2[0] > dArray2[1]) {
                    int n = nArray[0];
                    dArray[n] = dArray[n] + 1.0;
                    continue;
                }
                int n = nArray[1];
                dArray[n] = dArray[n] + 1.0;
            }
        } else {
            for (int i = 0; i < this.m_ClassFilters.length; ++i) {
                this.m_ClassFilters[i].input(instance);
                this.m_ClassFilters[i].batchFinished();
                double[] dArray3 = this.m_Classifiers[i].distributionForInstance(this.m_ClassFilters[i].output());
                for (int j = 0; j < this.m_ClassAttribute.numValues(); ++j) {
                    if (((MakeIndicator)this.m_ClassFilters[i]).getValueRange().isInRange(j)) {
                        int n = j;
                        dArray[n] = dArray[n] + dArray3[1];
                        continue;
                    }
                    int n = j;
                    dArray[n] = dArray[n] + dArray3[0];
                }
            }
        }
        if (Utils.gr(Utils.sum(dArray), 0.0)) {
            Utils.normalize(dArray);
            return dArray;
        }
        return this.m_ZeroR.distributionForInstance(instance);
    }

    public String toString() {
        if (this.m_Classifiers == null) {
            return "MultiClassClassifier: No model built yet.";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MultiClassClassifier\n\n");
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            stringBuffer.append("Classifier ").append(i + 1);
            if (this.m_Classifiers[i] != null) {
                if (this.m_ClassFilters != null && this.m_ClassFilters[i] != null) {
                    if (this.m_ClassFilters[i] instanceof RemoveWithValues) {
                        Range range = new Range(((RemoveWithValues)this.m_ClassFilters[i]).getNominalIndices());
                        range.setUpper(this.m_ClassAttribute.numValues());
                        int[] nArray = range.getSelection();
                        stringBuffer.append(", " + (nArray[0] + 1) + " vs " + (nArray[1] + 1));
                    } else if (this.m_ClassFilters[i] instanceof MakeIndicator) {
                        stringBuffer.append(", using indicator values: ");
                        stringBuffer.append(((MakeIndicator)this.m_ClassFilters[i]).getValueRange());
                    }
                }
                stringBuffer.append('\n');
                stringBuffer.append(this.m_Classifiers[i].toString() + "\n\n");
                continue;
            }
            stringBuffer.append(" Skipped (no training examples)\n");
        }
        return stringBuffer.toString();
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(3);
        vector.addElement(new Option("\tSets the method to use. Valid values are 0 (1-against-all),\n\t1 (random codes), 2 (exhaustive code), and 3 (1-against-1). (default 0)\n", "M", 1, "-M <num>"));
        vector.addElement(new Option("\tSets the multiplier when using random codes. (default 2.0)", "R", 1, "-R <num>"));
        vector.addElement(new Option("\tSets the base classifier.", "W", 1, "-W <base classifier>"));
        vector.addElement(new Option("\tSets the random number seed for random codes.", "Q", 1, "-Q <random number seed>"));
        if (this.m_Classifier != null) {
            try {
                vector.addElement(new Option("", "", 0, "\nOptions specific to classifier " + this.m_Classifier.getClass().getName() + ":"));
                Enumeration enumeration = this.m_Classifier.listOptions();
                while (enumeration.hasMoreElements()) {
                    vector.addElement((Option)enumeration.nextElement());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('M', stringArray);
        if (string.length() != 0) {
            this.setMethod(new SelectedTag(Integer.parseInt(string), TAGS_METHOD));
        } else {
            this.setMethod(new SelectedTag(0, TAGS_METHOD));
        }
        String string2 = Utils.getOption('R', stringArray);
        if (string2.length() != 0) {
            this.setRandomWidthFactor(new Double(string2));
        } else {
            this.setRandomWidthFactor(2.0);
        }
        String string3 = Utils.getOption('Q', stringArray);
        if (string3.length() != 0) {
            this.setSeed(Integer.parseInt(string3));
        } else {
            this.setSeed(1);
        }
        String string4 = Utils.getOption('W', stringArray);
        if (string4.length() == 0) {
            throw new Exception("A classifier must be specified with the -W option.");
        }
        this.setClassifier(Classifier.forName(string4, Utils.partitionOptions(stringArray)));
    }

    public String[] getOptions() {
        String[] stringArray = new String[]{};
        if (this.m_Classifier != null && this.m_Classifier instanceof OptionHandler) {
            stringArray = this.m_Classifier.getOptions();
        }
        String[] stringArray2 = new String[stringArray.length + 9];
        int n = 0;
        stringArray2[n++] = "-M";
        stringArray2[n++] = "" + this.m_Method;
        stringArray2[n++] = "-R";
        stringArray2[n++] = "" + this.m_RandomWidthFactor;
        stringArray2[n++] = "-Q";
        stringArray2[n++] = "" + this.getSeed();
        if (this.getClassifier() != null) {
            stringArray2[n++] = "-W";
            stringArray2[n++] = this.getClassifier().getClass().getName();
        }
        stringArray2[n++] = "--";
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        n += stringArray.length;
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public String globalInfo() {
        return "A metaclassifier for handling multi-class datasets with 2-class classifiers. This classifier is also capable of applying error correcting output codes for increased accuracy.";
    }

    public String randomWidthFactorTipText() {
        return "Sets the width multiplier when using random codes. The number of codes generated will be thus number multiplied by the number of classes.";
    }

    public double getRandomWidthFactor() {
        return this.m_RandomWidthFactor;
    }

    public void setRandomWidthFactor(double d) {
        this.m_RandomWidthFactor = d;
    }

    public String methodTipText() {
        return "Sets the method to use for transforming the multi-class problem into several 2-class ones.";
    }

    public SelectedTag getMethod() {
        return new SelectedTag(this.m_Method, TAGS_METHOD);
    }

    public void setMethod(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_METHOD) {
            this.m_Method = selectedTag.getSelectedTag().getID();
        }
    }

    public String classifierTipText() {
        return "Sets the Classifier used as the basis for the multi-class classifier.";
    }

    public void setClassifier(Classifier classifier) {
        this.m_Classifier = classifier;
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    public void setSeed(int n) {
        this.m_Seed = n;
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public static void main(String[] stringArray) {
        try {
            MultiClassClassifier multiClassClassifier = new MultiClassClassifier();
            System.out.println(Evaluation.evaluateModel(multiClassClassifier, stringArray));
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    private class ExhaustiveCode
    extends Code {
        public ExhaustiveCode(int n) {
            int n2;
            int n3 = (int)Math.pow(2.0, n - 1) - 1;
            this.m_Codebits = new boolean[n3][n];
            for (n2 = 0; n2 < n3; ++n2) {
                this.m_Codebits[n2][0] = true;
            }
            for (n2 = 1; n2 < n; ++n2) {
                int n4 = (int)Math.pow(2.0, n - (n2 + 1));
                for (int i = 0; i < n3; ++i) {
                    this.m_Codebits[i][n2] = i / n4 % 2 != 0;
                }
            }
        }
    }

    private class RandomCode
    extends Code {
        Random r = null;

        public RandomCode(int n, int n2, Instances instances) {
            this.r = instances.getRandomNumberGenerator(MultiClassClassifier.this.m_Seed);
            n2 = Math.max(n, n2);
            this.m_Codebits = new boolean[n2][n];
            int n3 = 0;
            do {
                this.randomize();
            } while (!this.good() && n3++ < 100);
        }

        private boolean good() {
            int n;
            boolean[] blArray = new boolean[this.m_Codebits[0].length];
            boolean[] blArray2 = new boolean[this.m_Codebits[0].length];
            for (n = 0; n < blArray2.length; ++n) {
                blArray2[n] = true;
            }
            for (n = 0; n < this.m_Codebits.length; ++n) {
                boolean bl = false;
                boolean bl2 = true;
                for (int i = 0; i < this.m_Codebits[n].length; ++i) {
                    boolean bl3 = this.m_Codebits[n][i];
                    bl = bl || bl3;
                    bl2 = bl2 && bl3;
                    blArray[i] = blArray[i] || bl3;
                    blArray2[i] = blArray2[i] && bl3;
                }
                if (bl && !bl2) continue;
                return false;
            }
            for (n = 0; n < blArray.length; ++n) {
                if (blArray[n] && !blArray2[n]) continue;
                return false;
            }
            return true;
        }

        private void randomize() {
            for (int i = 0; i < this.m_Codebits.length; ++i) {
                for (int j = 0; j < this.m_Codebits[i].length; ++j) {
                    double d = this.r.nextDouble();
                    this.m_Codebits[i][j] = !(d < 0.5);
                }
            }
        }
    }

    private class StandardCode
    extends Code {
        public StandardCode(int n) {
            this.m_Codebits = new boolean[n][n];
            for (int i = 0; i < n; ++i) {
                this.m_Codebits[i][i] = true;
            }
        }
    }

    private abstract class Code
    implements Serializable {
        protected boolean[][] m_Codebits;

        private Code() {
        }

        public int size() {
            return this.m_Codebits.length;
        }

        public String getIndices(int n) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.m_Codebits[n].length; ++i) {
                if (!this.m_Codebits[n][i]) continue;
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(i + 1);
            }
            return stringBuffer.toString();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.m_Codebits[0].length; ++i) {
                for (int j = 0; j < this.m_Codebits.length; ++j) {
                    stringBuffer.append(this.m_Codebits[j][i] ? " 1" : " 0");
                }
                stringBuffer.append('\n');
            }
            return stringBuffer.toString();
        }
    }
}

