/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import weka.clusterers.Clusterer;
import weka.core.Instance;
import weka.core.Utils;

public abstract class DensityBasedClusterer
extends Clusterer {
    public abstract double[] clusterPriors() throws Exception;

    public abstract double[] logDensityPerClusterForInstance(Instance var1) throws Exception;

    public double logDensityForInstance(Instance instance) throws Exception {
        double[] dArray = this.logJointDensitiesForInstance(instance);
        double d = dArray[Utils.maxIndex(dArray)];
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d2 += Math.exp(dArray[i] - d);
        }
        return d + Math.log(d2);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        return Utils.logs2probs(this.logJointDensitiesForInstance(instance));
    }

    protected double[] logJointDensitiesForInstance(Instance instance) throws Exception {
        double[] dArray = this.logDensityPerClusterForInstance(instance);
        double[] dArray2 = this.clusterPriors();
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray2[i] > 0.0)) {
                throw new IllegalArgumentException("Cluster empty!");
            }
            int n = i;
            dArray[n] = dArray[n] + Math.log(dArray2[i]);
        }
        return dArray;
    }
}

