/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.IOException;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.converters.AbstractLoader;
import weka.core.converters.BatchConverter;
import weka.core.converters.DatabaseConnection;
import weka.core.converters.DatabaseConverter;
import weka.core.converters.IncrementalConverter;

public class DatabaseLoader
extends AbstractLoader
implements BatchConverter,
IncrementalConverter,
DatabaseConverter,
OptionHandler {
    protected Instances m_structure;
    private Instances m_datasetPseudoInc;
    private Instances m_oldStructure;
    private DatabaseConnection m_DataBaseConnection;
    private String m_query;
    private boolean m_pseudoIncremental;
    private int m_nominalToStringLimit;
    private int m_rowCount;
    private int m_counter;
    private int m_choice;
    private boolean m_firstTime;
    private boolean m_inc;
    private FastVector m_orderBy;
    private Hashtable[] m_nominalIndexes;
    private FastVector[] m_nominalStrings;
    private String m_idColumn;
    public static final int STRING = 0;
    public static final int BOOL = 1;
    public static final int DOUBLE = 2;
    public static final int BYTE = 3;
    public static final int SHORT = 4;
    public static final int INTEGER = 5;
    public static final int LONG = 6;
    public static final int FLOAT = 7;
    public static final int DATE = 8;
    protected static String PROPERTY_FILE = "weka/experiment/DatabaseUtils.props";
    protected static Properties PROPERTIES;

    public DatabaseLoader() throws Exception {
        this.reset();
        this.m_pseudoIncremental = false;
        String string = PROPERTIES.getProperty("nominalToStringLimit");
        this.m_nominalToStringLimit = Integer.parseInt(string);
        this.m_idColumn = PROPERTIES.getProperty("idColumn");
    }

    public String globalInfo() {
        return "Reads Instances from a Database";
    }

    public void reset() throws Exception {
        this.resetStructure();
        if (this.m_DataBaseConnection != null && this.m_DataBaseConnection.isConnected()) {
            this.m_DataBaseConnection.disconnectFromDatabase();
        }
        this.m_DataBaseConnection = new DatabaseConnection();
        this.m_orderBy = new FastVector();
        this.m_query = "Select * from Results0";
        this.m_inc = false;
    }

    public void resetStructure() {
        this.m_structure = null;
        this.m_datasetPseudoInc = null;
        this.m_oldStructure = null;
        this.m_rowCount = 0;
        this.m_counter = 0;
        this.m_choice = 0;
        this.m_firstTime = true;
        this.setRetrieval(0);
    }

    public void setQuery(String string) {
        string = string.replaceAll("[fF][rR][oO][mM]", "FROM");
        this.m_query = string = string.replaceFirst("[sS][eE][lL][eE][cC][tT]", "SELECT");
    }

    public String getQuery() {
        return this.m_query;
    }

    public String queryTipText() {
        return "The query that should load the instances.\n The query has to be of the form SELECT <column-list>|* FROM <table> [WHERE <conditions>]";
    }

    public void setKeys(String string) {
        this.m_orderBy.removeAllElements();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            string2 = string2.replaceAll(" ", "");
            this.m_orderBy.addElement(string2);
        }
    }

    public String getKeys() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_orderBy.size(); ++i) {
            stringBuffer.append((String)this.m_orderBy.elementAt(i));
            if (i == this.m_orderBy.size() - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public String keysTipText() {
        return "For incremental loading a unique identiefer has to be specified.\nIf the query includes all columns of a table (SELECT *...) a primary key\ncan be detected automatically depending on the JDBC driver. If that is not possible\nspecify the key columns here in a comma separated list.";
    }

    public void setUrl(String string) {
        this.m_DataBaseConnection.setDatabaseURL(string);
    }

    public String getUrl() {
        return this.m_DataBaseConnection.getDatabaseURL();
    }

    public String urlTipText() {
        return "The URL of the database";
    }

    public void setUser(String string) {
        this.m_DataBaseConnection.setUsername(string);
    }

    public String getUser() {
        return this.m_DataBaseConnection.getUsername();
    }

    public String userTipText() {
        return "The user name for the database";
    }

    public void setPassword(String string) {
        this.m_DataBaseConnection.setPassword(string);
    }

    public String passwordTipText() {
        return "The database password";
    }

    public void setSource(String string, String string2, String string3) {
        try {
            this.m_DataBaseConnection = new DatabaseConnection();
            this.m_DataBaseConnection.setDatabaseURL(string);
            this.m_DataBaseConnection.setUsername(string2);
            this.m_DataBaseConnection.setPassword(string3);
        }
        catch (Exception exception) {
            this.printException(exception);
        }
    }

    public void setSource(String string) {
        try {
            this.m_DataBaseConnection = new DatabaseConnection();
            this.m_DataBaseConnection.setDatabaseURL(string);
        }
        catch (Exception exception) {
            this.printException(exception);
        }
    }

    public void setSource() throws Exception {
        this.m_DataBaseConnection = new DatabaseConnection();
    }

    public void connectToDatabase() {
        try {
            if (!this.m_DataBaseConnection.isConnected()) {
                this.m_DataBaseConnection.connectToDatabase();
            }
        }
        catch (Exception exception) {
            this.printException(exception);
        }
    }

    private String endOfQuery(boolean bl) {
        int n = this.m_query.indexOf("FROM ") + 5;
        while (this.m_query.charAt(n) == ' ') {
            ++n;
        }
        int n2 = this.m_query.indexOf(" ", n);
        String string = n2 != -1 && bl ? this.m_query.substring(n, n2) : this.m_query.substring(n);
        if (this.m_DataBaseConnection.getUpperCase()) {
            string = string.toUpperCase();
        }
        return string;
    }

    private boolean checkForKey() throws Exception {
        String string = this.m_query;
        if (!(string = string.replaceAll(" +", " ")).startsWith("SELECT *")) {
            return false;
        }
        this.m_orderBy.removeAllElements();
        if (!this.m_DataBaseConnection.isConnected()) {
            this.m_DataBaseConnection.connectToDatabase();
        }
        DatabaseMetaData databaseMetaData = this.m_DataBaseConnection.getMetaData();
        String string2 = this.endOfQuery(true);
        ResultSet resultSet = databaseMetaData.getPrimaryKeys(null, null, string2);
        while (resultSet.next()) {
            this.m_orderBy.addElement(resultSet.getString(4));
        }
        resultSet.close();
        if (this.m_orderBy.size() != 0) {
            return true;
        }
        resultSet = databaseMetaData.getBestRowIdentifier(null, null, string2, 2, false);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = 0;
        while (resultSet.next()) {
            this.m_orderBy.addElement(resultSet.getString(2));
            ++n;
        }
        resultSet.close();
        if (n == resultSetMetaData.getColumnCount()) {
            this.m_orderBy.removeAllElements();
        }
        return this.m_orderBy.size() != 0;
    }

    private void stringToNominal(ResultSet resultSet, int n) throws Exception {
        while (resultSet.next()) {
            Double d;
            String string = resultSet.getString(1);
            if (resultSet.wasNull() || (d = (Double)this.m_nominalIndexes[n - 1].get(string)) != null) continue;
            d = new Double(this.m_nominalStrings[n - 1].size());
            this.m_nominalIndexes[n - 1].put(string, d);
            this.m_nominalStrings[n - 1].addElement(string);
        }
    }

    private String limitQuery(String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        if (this.m_orderBy.size() != 0) {
            stringBuffer.append(" ORDER BY ");
            for (int i = 0; i < this.m_orderBy.size() - 1; ++i) {
                if (this.m_DataBaseConnection.getUpperCase()) {
                    stringBuffer.append(((String)this.m_orderBy.elementAt(i)).toUpperCase());
                } else {
                    stringBuffer.append((String)this.m_orderBy.elementAt(i));
                }
                stringBuffer.append(", ");
            }
            if (this.m_DataBaseConnection.getUpperCase()) {
                stringBuffer.append(((String)this.m_orderBy.elementAt(this.m_orderBy.size() - 1)).toUpperCase());
            } else {
                stringBuffer.append((String)this.m_orderBy.elementAt(this.m_orderBy.size() - 1));
            }
            string2 = stringBuffer.toString();
        }
        if (n2 == 0) {
            String string3 = string.replaceFirst("SELECT", "SELECT LIMIT " + n + " 1");
            string3 = string3.concat(string2);
            return string3;
        }
        if (n2 == 1) {
            String string4 = string.concat(string2 + " LIMIT 1 OFFSET " + n);
            return string4;
        }
        String string5 = string.concat(string2 + " LIMIT " + n + ", 1");
        return string5;
    }

    private int getRowCount() throws Exception {
        String string = "SELECT COUNT(*) FROM " + this.endOfQuery(false);
        if (!this.m_DataBaseConnection.execute(string)) {
            throw new Exception("Cannot count results tuples.");
        }
        ResultSet resultSet = this.m_DataBaseConnection.getResultSet();
        resultSet.next();
        int n = resultSet.getInt(1);
        resultSet.close();
        return n;
    }

    public Instances getStructure() throws IOException {
        block39: {
            if (this.m_DataBaseConnection == null) {
                throw new IOException("No source database has been specified");
            }
            this.connectToDatabase();
            try {
                if (this.m_pseudoIncremental && this.m_structure == null) {
                    if (this.getRetrieval() == 1) {
                        throw new IOException("Cannot mix getting instances in both incremental and batch modes");
                    }
                    this.setRetrieval(0);
                    this.m_datasetPseudoInc = this.getDataSet();
                    this.m_structure = new Instances(this.m_datasetPseudoInc, 0);
                    this.setRetrieval(0);
                    return this.m_structure;
                }
                if (this.m_structure == null) {
                    String string;
                    if (!this.m_DataBaseConnection.tableExists(this.endOfQuery(true))) {
                        throw new IOException("Table does not exist.");
                    }
                    int n = 0;
                    boolean bl = false;
                    while (!bl) {
                        try {
                            if (!this.m_DataBaseConnection.execute(this.limitQuery(this.m_query, 0, n))) {
                                throw new IOException("Query didn't produce results");
                            }
                            this.m_choice = n;
                            bl = true;
                        }
                        catch (SQLException sQLException) {
                            if (++n != 3) continue;
                            System.out.println("Incremental loading not supported for that DBMS. Pseudoincremental mode is used if you use incremental loading.\nAll rows are loaded into memory once and retrieved incrementally from memory instead of from the database.");
                            this.m_pseudoIncremental = true;
                            break block39;
                        }
                    }
                    String string2 = this.endOfQuery(false);
                    ResultSet resultSet = this.m_DataBaseConnection.getResultSet();
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    resultSet.close();
                    int n2 = resultSetMetaData.getColumnCount();
                    int[] nArray = new int[n2];
                    this.m_nominalIndexes = new Hashtable[n2];
                    this.m_nominalStrings = new FastVector[n2];
                    block22: for (int i = 1; i <= n2; ++i) {
                        switch (this.m_DataBaseConnection.translateDBColumnType(resultSetMetaData.getColumnTypeName(i))) {
                            case 0: {
                                ResultSet resultSet2;
                                string = resultSetMetaData.getColumnName(i);
                                if (this.m_DataBaseConnection.getUpperCase()) {
                                    string = string.toUpperCase();
                                }
                                this.m_nominalIndexes[i - 1] = new Hashtable();
                                this.m_nominalStrings[i - 1] = new FastVector();
                                String string3 = "SELECT COUNT(DISTINCT( " + string + " )) FROM " + string2;
                                if (this.m_DataBaseConnection.execute(string3)) {
                                    resultSet2 = this.m_DataBaseConnection.getResultSet();
                                    resultSet2.next();
                                    int n3 = resultSet2.getInt(1);
                                    resultSet2.close();
                                    if (n3 > this.m_nominalToStringLimit || !this.m_DataBaseConnection.execute("SELECT DISTINCT ( " + string + " ) FROM " + string2)) {
                                        nArray[i - 1] = 2;
                                        continue block22;
                                    }
                                } else {
                                    nArray[i - 1] = 2;
                                    continue block22;
                                }
                                resultSet2 = this.m_DataBaseConnection.getResultSet();
                                nArray[i - 1] = 1;
                                this.stringToNominal(resultSet2, i);
                                resultSet2.close();
                                continue block22;
                            }
                            case 1: {
                                nArray[i - 1] = 1;
                                this.m_nominalIndexes[i - 1] = new Hashtable();
                                this.m_nominalIndexes[i - 1].put("false", new Double(0.0));
                                this.m_nominalIndexes[i - 1].put("true", new Double(1.0));
                                this.m_nominalStrings[i - 1] = new FastVector();
                                this.m_nominalStrings[i - 1].addElement("false");
                                this.m_nominalStrings[i - 1].addElement("true");
                                continue block22;
                            }
                            case 2: {
                                nArray[i - 1] = 0;
                                continue block22;
                            }
                            case 3: {
                                nArray[i - 1] = 0;
                                continue block22;
                            }
                            case 4: {
                                nArray[i - 1] = 0;
                                continue block22;
                            }
                            case 5: {
                                nArray[i - 1] = 0;
                                continue block22;
                            }
                            case 6: {
                                nArray[i - 1] = 0;
                                continue block22;
                            }
                            case 7: {
                                nArray[i - 1] = 0;
                                continue block22;
                            }
                            case 8: {
                                nArray[i - 1] = 3;
                                continue block22;
                            }
                            default: {
                                nArray[i - 1] = 2;
                            }
                        }
                    }
                    FastVector fastVector = new FastVector();
                    block23: for (int i = 0; i < n2; ++i) {
                        string = resultSetMetaData.getColumnName(i + 1);
                        switch (nArray[i]) {
                            case 1: {
                                fastVector.addElement(new Attribute(string, this.m_nominalStrings[i]));
                                continue block23;
                            }
                            case 0: {
                                fastVector.addElement(new Attribute(string));
                                continue block23;
                            }
                            case 2: {
                                fastVector.addElement(new Attribute(string, (FastVector)null));
                                continue block23;
                            }
                            case 3: {
                                fastVector.addElement(new Attribute(string, (String)null));
                                continue block23;
                            }
                            default: {
                                throw new IOException("Unknown attribute type");
                            }
                        }
                    }
                    this.m_structure = new Instances(this.endOfQuery(true), fastVector, 0);
                    if (this.m_DataBaseConnection.getUpperCase()) {
                        this.m_idColumn = this.m_idColumn.toUpperCase();
                    }
                    if (this.m_structure.attribute(0).name().equals(this.m_idColumn)) {
                        this.m_oldStructure = new Instances(this.m_structure, 0);
                        this.m_oldStructure.deleteAttributeAt(0);
                    } else {
                        this.m_oldStructure = new Instances(this.m_structure, 0);
                    }
                } else if (this.m_oldStructure == null) {
                    this.m_oldStructure = new Instances(this.m_structure, 0);
                }
                this.m_DataBaseConnection.disconnectFromDatabase();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.printException(exception);
            }
        }
        return this.m_oldStructure;
    }

    public Instances getDataSet() throws IOException {
        Instances instances;
        block53: {
            if (this.m_DataBaseConnection == null) {
                throw new IOException("No source database has been specified");
            }
            if (this.getRetrieval() == 2) {
                throw new IOException("Cannot mix getting Instances in both incremental and batch modes");
            }
            this.setRetrieval(1);
            this.connectToDatabase();
            instances = null;
            try {
                int n;
                Object object;
                String string;
                Object object2;
                if (!this.m_DataBaseConnection.execute(this.m_query)) {
                    throw new Exception("Query didn't produce results");
                }
                ResultSet resultSet = this.m_DataBaseConnection.getResultSet();
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n2 = resultSetMetaData.getColumnCount();
                int[] nArray = new int[n2];
                this.m_nominalIndexes = new Hashtable[n2];
                this.m_nominalStrings = new FastVector[n2];
                block30: for (int i = 1; i <= n2; ++i) {
                    switch (this.m_DataBaseConnection.translateDBColumnType(resultSetMetaData.getColumnTypeName(i))) {
                        case 0: {
                            object2 = resultSetMetaData.getColumnName(i);
                            if (this.m_DataBaseConnection.getUpperCase()) {
                                object2 = ((String)object2).toUpperCase();
                            }
                            string = this.endOfQuery(false);
                            this.m_nominalIndexes[i - 1] = new Hashtable();
                            this.m_nominalStrings[i - 1] = new FastVector();
                            if (!this.m_DataBaseConnection.execute("SELECT DISTINCT ( " + (String)object2 + " ) FROM " + string)) {
                                throw new Exception("Nominal values cannot be retrieved");
                            }
                            object = this.m_DataBaseConnection.getResultSet();
                            nArray[i - 1] = 1;
                            this.stringToNominal((ResultSet)object, i);
                            object.close();
                            continue block30;
                        }
                        case 1: {
                            nArray[i - 1] = 1;
                            this.m_nominalIndexes[i - 1] = new Hashtable();
                            this.m_nominalIndexes[i - 1].put("false", new Double(0.0));
                            this.m_nominalIndexes[i - 1].put("true", new Double(1.0));
                            this.m_nominalStrings[i - 1] = new FastVector();
                            this.m_nominalStrings[i - 1].addElement("false");
                            this.m_nominalStrings[i - 1].addElement("true");
                            continue block30;
                        }
                        case 2: {
                            nArray[i - 1] = 0;
                            continue block30;
                        }
                        case 3: {
                            nArray[i - 1] = 0;
                            continue block30;
                        }
                        case 4: {
                            nArray[i - 1] = 0;
                            continue block30;
                        }
                        case 5: {
                            nArray[i - 1] = 0;
                            continue block30;
                        }
                        case 6: {
                            nArray[i - 1] = 0;
                            continue block30;
                        }
                        case 7: {
                            nArray[i - 1] = 0;
                            continue block30;
                        }
                        case 8: {
                            nArray[i - 1] = 3;
                            continue block30;
                        }
                        default: {
                            nArray[i - 1] = 2;
                        }
                    }
                }
                FastVector fastVector = new FastVector();
                while (resultSet.next()) {
                    object = new double[n2];
                    block32: for (int i = 1; i <= n2; ++i) {
                        switch (this.m_DataBaseConnection.translateDBColumnType(resultSetMetaData.getColumnTypeName(i))) {
                            case 0: {
                                string = resultSet.getString(i);
                                if (resultSet.wasNull()) {
                                    object[i - 1] = Instance.missingValue();
                                    continue block32;
                                }
                                Double d = (Double)this.m_nominalIndexes[i - 1].get(string);
                                if (d == null) {
                                    d = new Double(this.m_structure.attribute(i - 1).addStringValue(string));
                                }
                                object[i - 1] = d;
                                continue block32;
                            }
                            case 1: {
                                boolean bl = resultSet.getBoolean(i);
                                if (resultSet.wasNull()) {
                                    object[i - 1] = Instance.missingValue();
                                    continue block32;
                                }
                                object[i - 1] = bl ? 1.0 : 0.0;
                                continue block32;
                            }
                            case 2: {
                                double d = resultSet.getDouble(i);
                                if (resultSet.wasNull()) {
                                    object[i - 1] = Instance.missingValue();
                                    continue block32;
                                }
                                object[i - 1] = d;
                                continue block32;
                            }
                            case 3: {
                                byte by = resultSet.getByte(i);
                                if (resultSet.wasNull()) {
                                    object[i - 1] = Instance.missingValue();
                                    continue block32;
                                }
                                object[i - 1] = (double)by;
                                continue block32;
                            }
                            case 4: {
                                short s = resultSet.getByte(i);
                                if (resultSet.wasNull()) {
                                    object[i - 1] = Instance.missingValue();
                                    continue block32;
                                }
                                object[i - 1] = (double)s;
                                continue block32;
                            }
                            case 5: {
                                int n3 = resultSet.getInt(i);
                                if (resultSet.wasNull()) {
                                    object[i - 1] = Instance.missingValue();
                                    continue block32;
                                }
                                object[i - 1] = (double)n3;
                                continue block32;
                            }
                            case 6: {
                                long l = resultSet.getLong(i);
                                if (resultSet.wasNull()) {
                                    object[i - 1] = Instance.missingValue();
                                    continue block32;
                                }
                                object[i - 1] = (double)l;
                                continue block32;
                            }
                            case 7: {
                                float f = resultSet.getFloat(i);
                                if (resultSet.wasNull()) {
                                    object[i - 1] = Instance.missingValue();
                                    continue block32;
                                }
                                object[i - 1] = (double)f;
                                continue block32;
                            }
                            case 8: {
                                Date date = resultSet.getDate(i);
                                if (resultSet.wasNull()) {
                                    object[i - 1] = Instance.missingValue();
                                    continue block32;
                                }
                                object[i - 1] = (double)date.getTime();
                                continue block32;
                            }
                            default: {
                                object[i - 1] = Instance.missingValue();
                            }
                        }
                    }
                    object2 = new Instance(1.0, (double[])object);
                    fastVector.addElement(object2);
                }
                object = new FastVector();
                block33: for (n = 0; n < n2; ++n) {
                    string = resultSetMetaData.getColumnName(n + 1);
                    switch (nArray[n]) {
                        case 1: {
                            ((FastVector)object).addElement(new Attribute(string, this.m_nominalStrings[n]));
                            continue block33;
                        }
                        case 0: {
                            ((FastVector)object).addElement(new Attribute(string));
                            continue block33;
                        }
                        case 2: {
                            ((FastVector)object).addElement(new Attribute(string, (FastVector)null));
                            continue block33;
                        }
                        case 3: {
                            ((FastVector)object).addElement(new Attribute(string, (String)null));
                            continue block33;
                        }
                        default: {
                            throw new IOException("Unknown attribute type");
                        }
                    }
                }
                instances = new Instances(this.endOfQuery(true), (FastVector)object, fastVector.size());
                for (n = 0; n < fastVector.size(); ++n) {
                    instances.add((Instance)fastVector.elementAt(n));
                }
                resultSet.close();
                this.m_DataBaseConnection.disconnectFromDatabase();
                if (this.m_DataBaseConnection.getUpperCase()) {
                    this.m_idColumn = this.m_idColumn.toUpperCase();
                }
                if (instances.attribute(0).name().equals(this.m_idColumn)) {
                    instances.deleteAttributeAt(0);
                }
                this.m_structure = new Instances(instances, 0);
            }
            catch (Exception exception) {
                this.printException(exception);
                StringBuffer stringBuffer = new StringBuffer();
                if (!this.m_query.equals("Select * from Results0")) break block53;
                stringBuffer.append("\n\nDatabaseLoader options:\n");
                Enumeration enumeration = this.listOptions();
                while (enumeration.hasMoreElements()) {
                    Option option = (Option)enumeration.nextElement();
                    stringBuffer.append(option.synopsis() + '\n');
                    stringBuffer.append(option.description() + '\n');
                }
                System.out.println(stringBuffer);
            }
        }
        return instances;
    }

    private Instance readInstance(ResultSet resultSet) throws Exception {
        FastVector fastVector = new FastVector();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        double[] dArray = new double[n];
        this.m_structure.delete();
        block11: for (int i = 1; i <= n; ++i) {
            switch (this.m_DataBaseConnection.translateDBColumnType(resultSetMetaData.getColumnTypeName(i))) {
                case 0: {
                    String string = resultSet.getString(i);
                    if (resultSet.wasNull()) {
                        dArray[i - 1] = Instance.missingValue();
                        continue block11;
                    }
                    Double d = (Double)this.m_nominalIndexes[i - 1].get(string);
                    if (d == null) {
                        d = new Double(this.m_structure.attribute(i - 1).addStringValue(string));
                    }
                    dArray[i - 1] = d;
                    continue block11;
                }
                case 1: {
                    boolean bl = resultSet.getBoolean(i);
                    if (resultSet.wasNull()) {
                        dArray[i - 1] = Instance.missingValue();
                        continue block11;
                    }
                    dArray[i - 1] = bl ? 1.0 : 0.0;
                    continue block11;
                }
                case 2: {
                    double d = resultSet.getDouble(i);
                    if (resultSet.wasNull()) {
                        dArray[i - 1] = Instance.missingValue();
                        continue block11;
                    }
                    dArray[i - 1] = d;
                    continue block11;
                }
                case 3: {
                    byte by = resultSet.getByte(i);
                    if (resultSet.wasNull()) {
                        dArray[i - 1] = Instance.missingValue();
                        continue block11;
                    }
                    dArray[i - 1] = by;
                    continue block11;
                }
                case 4: {
                    short s = resultSet.getByte(i);
                    if (resultSet.wasNull()) {
                        dArray[i - 1] = Instance.missingValue();
                        continue block11;
                    }
                    dArray[i - 1] = s;
                    continue block11;
                }
                case 5: {
                    int n2 = resultSet.getInt(i);
                    if (resultSet.wasNull()) {
                        dArray[i - 1] = Instance.missingValue();
                        continue block11;
                    }
                    dArray[i - 1] = n2;
                    continue block11;
                }
                case 6: {
                    long l = resultSet.getLong(i);
                    if (resultSet.wasNull()) {
                        dArray[i - 1] = Instance.missingValue();
                        continue block11;
                    }
                    dArray[i - 1] = l;
                    continue block11;
                }
                case 7: {
                    float f = resultSet.getFloat(i);
                    if (resultSet.wasNull()) {
                        dArray[i - 1] = Instance.missingValue();
                        continue block11;
                    }
                    dArray[i - 1] = f;
                    continue block11;
                }
                case 8: {
                    Date date = resultSet.getDate(i);
                    if (resultSet.wasNull()) {
                        dArray[i - 1] = Instance.missingValue();
                        continue block11;
                    }
                    dArray[i - 1] = date.getTime();
                    continue block11;
                }
                default: {
                    dArray[i - 1] = Instance.missingValue();
                }
            }
        }
        Instance instance = new Instance(1.0, dArray);
        if (this.m_DataBaseConnection.getUpperCase()) {
            this.m_idColumn = this.m_idColumn.toUpperCase();
        }
        if (this.m_structure.attribute(0).name().equals(this.m_idColumn)) {
            instance.deleteAttributeAt(0);
            this.m_oldStructure.add(instance);
            instance = this.m_oldStructure.instance(0);
            this.m_oldStructure.delete(0);
        } else {
            this.m_structure.add(instance);
            instance = this.m_structure.instance(0);
            this.m_structure.delete(0);
        }
        return instance;
    }

    public Instance getNextInstance() throws IOException {
        if (this.m_DataBaseConnection == null) {
            throw new IOException("No source database has been specified");
        }
        if (this.getRetrieval() == 1) {
            throw new IOException("Cannot mix getting Instances in both incremental and batch modes");
        }
        if (this.m_pseudoIncremental) {
            if (this.m_structure == null) {
                this.setRetrieval(0);
                this.getStructure();
            }
            this.setRetrieval(2);
            if (this.m_datasetPseudoInc.numInstances() > 0) {
                Instance instance = this.m_datasetPseudoInc.instance(0);
                this.m_datasetPseudoInc.delete(0);
                return instance;
            }
            this.resetStructure();
            return null;
        }
        this.setRetrieval(2);
        try {
            if (!this.m_DataBaseConnection.isConnected()) {
                this.connectToDatabase();
            }
            if (this.m_structure == null) {
                this.m_structure = this.getStructure();
            }
            if (this.m_firstTime && this.m_orderBy.size() == 0 && !this.checkForKey()) {
                throw new Exception("A unique order cannot be detected automatically.\nYou have to use SELECT * in your query to enable this feature.\nMaybe JDBC driver is not able to detect key.\nDefine primary key in your database or use -P option (command line) or enter key columns in the GUI.");
            }
            if (this.m_firstTime) {
                this.m_firstTime = false;
                this.m_rowCount = this.getRowCount();
            }
            if (this.m_counter < this.m_rowCount) {
                if (!this.m_DataBaseConnection.execute(this.limitQuery(this.m_query, this.m_counter, this.m_choice))) {
                    throw new Exception("Tuple could not be retrieved.");
                }
                ++this.m_counter;
                ResultSet resultSet = this.m_DataBaseConnection.getResultSet();
                resultSet.next();
                Instance instance = this.readInstance(resultSet);
                resultSet.close();
                return instance;
            }
            this.m_DataBaseConnection.disconnectFromDatabase();
            this.resetStructure();
            return null;
        }
        catch (Exception exception) {
            this.printException(exception);
            return null;
        }
    }

    public String[] getOptions() {
        int n;
        String[] stringArray = new String[10];
        int n2 = 0;
        stringArray[n2] = "-Q";
        stringArray[n2++] = this.getQuery();
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.m_orderBy.size() - 1; ++n) {
            stringBuffer.append((String)this.m_orderBy.elementAt(n));
            stringBuffer.append(", ");
        }
        if (n == this.m_orderBy.size() - 1) {
            stringBuffer.append((String)this.m_orderBy.elementAt(n));
            stringArray[n2] = "-P";
            stringArray[n2++] = stringBuffer.toString();
        }
        if (this.m_inc) {
            stringArray[n2++] = "-I";
        }
        while (n2 < stringArray.length) {
            stringArray[n2++] = "";
        }
        return stringArray;
    }

    public Enumeration listOptions() {
        FastVector fastVector = new FastVector(3);
        fastVector.addElement(new Option("\tSQL query of the form SELECT <list of columns>|* FROM <table> [WHERE] to execute (default Select * From Results0).", "Q", 1, "-Q <query>"));
        fastVector.addElement(new Option("\tList of column names uniquely defining a DB row (separated by ', ').\n\tUsed for incremental loading.\n\tIf not specified, the key will be determined automatically, if possible with the used JDBC driver.\n\tThe auto ID column created by the DatabaseSaver won't be loaded.", "P", 1, "-P<list of column names>"));
        fastVector.addElement(new Option("\tSets incremental loading", "I", 0, "-I"));
        return fastVector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('Q', stringArray);
        String string2 = Utils.getOption('P', stringArray);
        this.reset();
        if (string.length() != 0) {
            this.setQuery(string);
        }
        this.m_orderBy.removeAllElements();
        this.m_inc = Utils.getFlag('I', stringArray);
        if (this.m_inc) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                string3 = string3.replaceAll(" ", "");
                this.m_orderBy.addElement(string3);
            }
        }
    }

    private void printException(Exception exception) {
        System.out.println("\n--- Exception caught ---\n");
        while (exception != null) {
            System.out.println("Message:   " + exception.getMessage());
            if (exception instanceof SQLException) {
                System.out.println("SQLState:  " + ((SQLException)exception).getSQLState());
                System.out.println("ErrorCode: " + ((SQLException)exception).getErrorCode());
                exception = ((SQLException)exception).getNextException();
            } else {
                exception = null;
            }
            System.out.println("");
        }
    }

    public static void main(String[] stringArray) {
        try {
            DatabaseLoader databaseLoader = new DatabaseLoader();
            databaseLoader.setOptions(stringArray);
            databaseLoader.setSource();
            if (!databaseLoader.m_inc) {
                System.out.println(databaseLoader.getDataSet());
            } else {
                Instance instance;
                System.out.println(databaseLoader.getStructure());
                do {
                    if ((instance = databaseLoader.getNextInstance()) == null) continue;
                    System.out.println(instance);
                } while (instance != null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("\n" + exception.getMessage());
        }
    }

    static {
        try {
            PROPERTIES = Utils.readProperties(PROPERTY_FILE);
        }
        catch (Exception exception) {
            System.err.println("Problem reading properties. Fix before continuing.");
            System.err.println(exception);
        }
    }
}

