/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weka.gui.Logger;
import weka.gui.TaskLogger;
import weka.gui.WekaTaskMonitor;

public class LogPanel
extends JPanel
implements Logger,
TaskLogger {
    protected JLabel m_StatusLab = new JLabel("OK");
    protected JTextArea m_LogText = new JTextArea(4, 20);
    protected JButton m_logButton = new JButton("Log");
    protected boolean m_First = true;
    protected WekaTaskMonitor m_TaskMonitor = null;

    public LogPanel() {
        this((WekaTaskMonitor)null, false);
    }

    public LogPanel(WekaTaskMonitor wekaTaskMonitor) {
        this(wekaTaskMonitor, true);
    }

    public LogPanel(WekaTaskMonitor wekaTaskMonitor, boolean bl) {
        this.m_TaskMonitor = wekaTaskMonitor;
        this.m_LogText.setEditable(false);
        this.m_LogText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_StatusLab.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Status"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        JScrollPane jScrollPane = new JScrollPane(this.m_LogText);
        jScrollPane.getViewport().addChangeListener(new ChangeListener(){
            private int lastHeight;

            public void stateChanged(ChangeEvent changeEvent) {
                JViewport jViewport = (JViewport)changeEvent.getSource();
                int n = jViewport.getViewSize().height;
                if (n != this.lastHeight) {
                    this.lastHeight = n;
                    int n2 = n - jViewport.getExtentSize().height;
                    jViewport.setViewPosition(new Point(0, n2));
                }
            }
        });
        if (bl) {
            final JFrame jFrame = new JFrame("Log");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.setVisible(false);
                }
            });
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add((Component)jScrollPane, "Center");
            jFrame.pack();
            jFrame.setSize(450, 350);
            this.m_logButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jFrame.setVisible(true);
                }
            });
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
            jPanel.add((Component)this.m_logButton, "Center");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)this.m_StatusLab, "Center");
            jPanel2.add((Component)jPanel, "East");
            if (wekaTaskMonitor == null) {
                this.add((Component)jPanel2, "South");
            } else {
                JPanel jPanel3 = new JPanel();
                jPanel3.setLayout(new BorderLayout());
                jPanel3.add((Component)jPanel2, "Center");
                jPanel3.add((Component)this.m_TaskMonitor, "East");
                this.add((Component)jPanel3, "South");
            }
        } else {
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createTitledBorder("Log"));
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)jScrollPane, "Center");
            this.setLayout(new BorderLayout());
            this.add((Component)jPanel, "Center");
            if (wekaTaskMonitor == null) {
                this.add((Component)this.m_StatusLab, "South");
            } else {
                JPanel jPanel4 = new JPanel();
                jPanel4.setLayout(new BorderLayout());
                jPanel4.add((Component)this.m_StatusLab, "Center");
                jPanel4.add((Component)this.m_TaskMonitor, "East");
                this.add((Component)jPanel4, "South");
            }
        }
        this.addPopup();
    }

    private void addPopup() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 0x10) != 16 || mouseEvent.isAltDown()) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JMenuItem jMenuItem = new JMenuItem("Available memory");
                    jMenuItem.addActionListener(new ActionListener(this){
                        private final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            System.gc();
                            Runtime runtime = Runtime.getRuntime();
                            long l = runtime.freeMemory();
                            4.access$000(this.this$1).logMessage("Available memory : " + l + " bytes");
                            4.access$000(this.this$1).statusMessage(l + " bytes free");
                        }
                    });
                    jPopupMenu.add(jMenuItem);
                    JMenuItem jMenuItem2 = new JMenuItem("Run garbage collector");
                    jMenuItem2.addActionListener(new ActionListener(this){
                        private final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            4.access$000(this.this$1).statusMessage("Running garbage collector");
                            System.gc();
                            4.access$000(this.this$1).statusMessage("OK");
                        }
                    });
                    jPopupMenu.add(jMenuItem2);
                    jPopupMenu.show(LogPanel.this, mouseEvent.getX(), mouseEvent.getY());
                }
            }

            static /* synthetic */ LogPanel access$000(4 var0) {
                return var0.LogPanel.this;
            }
        });
    }

    public void taskStarted() {
        if (this.m_TaskMonitor != null) {
            this.m_TaskMonitor.taskStarted();
        }
    }

    public void taskFinished() {
        if (this.m_TaskMonitor != null) {
            this.m_TaskMonitor.taskFinished();
        }
    }

    protected static String getTimestamp() {
        return new SimpleDateFormat("HH:mm:ss:").format(new Date());
    }

    public void logMessage(String string) {
        if (this.m_First) {
            this.m_First = false;
        } else {
            this.m_LogText.append("\n");
        }
        this.m_LogText.append(LogPanel.getTimestamp() + ' ' + string);
    }

    public void statusMessage(String string) {
        this.m_StatusLab.setText(string);
    }

    public static void main(String[] stringArray) {
        try {
            final JFrame jFrame = new JFrame("Log Panel");
            jFrame.getContentPane().setLayout(new BorderLayout());
            LogPanel logPanel = new LogPanel();
            jFrame.getContentPane().add((Component)logPanel, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setVisible(true);
            logPanel.logMessage("Welcome to the generic log panel!");
            logPanel.statusMessage("Hi there");
            logPanel.logMessage("Funky chickens");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

