/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorManager;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;
import weka.core.OptionHandler;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.experiment.Experiment;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertyDialog;

public class AlgorithmListPanel
extends JPanel
implements ActionListener {
    protected Experiment m_Exp;
    protected JList m_List;
    protected JButton m_AddBut = new JButton("Add new...");
    protected JButton m_DeleteBut = new JButton("Delete selected");
    protected GenericObjectEditor m_ClassifierEditor = new GenericObjectEditor(true);
    protected PropertyDialog m_PD;
    protected DefaultListModel m_AlgorithmListModel = new DefaultListModel();
    static /* synthetic */ Class class$weka$core$SelectedTag;
    static /* synthetic */ Class class$weka$gui$SelectedTagEditor;
    static /* synthetic */ Class class$weka$filters$Filter;
    static /* synthetic */ Class class$weka$gui$GenericObjectEditor;
    static /* synthetic */ Class array$Lweka$classifiers$Classifier;
    static /* synthetic */ Class class$weka$gui$GenericArrayEditor;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$weka$classifiers$Classifier;
    static /* synthetic */ Class class$weka$associations$CARuleMiner;
    static /* synthetic */ Class class$weka$classifiers$CostMatrix;
    static /* synthetic */ Class class$weka$gui$CostMatrixEditor;

    public AlgorithmListPanel(Experiment experiment) {
        this();
        this.setExperiment(experiment);
    }

    public AlgorithmListPanel() {
        this.m_List = new JList();
        this.m_ClassifierEditor.setClassType(class$weka$classifiers$Classifier == null ? (class$weka$classifiers$Classifier = AlgorithmListPanel.class$("weka.classifiers.Classifier")) : class$weka$classifiers$Classifier);
        this.m_ClassifierEditor.setValue(new ZeroR());
        this.m_ClassifierEditor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                AlgorithmListPanel.this.repaint();
            }
        });
        ((GenericObjectEditor.GOEPanel)this.m_ClassifierEditor.getCustomEditor()).addOkListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Classifier classifier = (Classifier)AlgorithmListPanel.this.copyObject(AlgorithmListPanel.this.m_ClassifierEditor.getValue());
                AlgorithmListPanel.this.addNewAlgorithm(classifier);
            }
        });
        this.m_DeleteBut.setEnabled(false);
        this.m_DeleteBut.addActionListener(this);
        this.m_AddBut.setEnabled(false);
        this.m_AddBut.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder("Algorithms"));
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        jPanel.add((Component)this.m_AddBut, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel.add((Component)this.m_DeleteBut, gridBagConstraints);
        this.add((Component)jPanel, "North");
        this.add((Component)new JScrollPane(this.m_List), "Center");
    }

    public void setExperiment(Experiment experiment) {
        this.m_Exp = experiment;
        this.m_AddBut.setEnabled(true);
        this.m_List.setModel(this.m_AlgorithmListModel);
        this.m_List.setCellRenderer(new ObjectCellRenderer());
        this.m_AlgorithmListModel.removeAllElements();
        if (this.m_Exp.getPropertyArray() instanceof Classifier[]) {
            Classifier[] classifierArray = (Classifier[])this.m_Exp.getPropertyArray();
            for (int i = 0; i < classifierArray.length; ++i) {
                this.m_AlgorithmListModel.addElement(classifierArray[i]);
            }
        }
        if (this.m_AlgorithmListModel.size() > 0) {
            this.m_DeleteBut.setEnabled(true);
        }
    }

    private void addNewAlgorithm(Classifier classifier) {
        this.m_AlgorithmListModel.addElement(classifier);
        Classifier[] classifierArray = new Classifier[this.m_AlgorithmListModel.size()];
        for (int i = 0; i < classifierArray.length; ++i) {
            classifierArray[i] = (Classifier)this.m_AlgorithmListModel.elementAt(i);
        }
        this.m_Exp.setPropertyArray(classifierArray);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_AddBut) {
            if (this.m_PD == null) {
                int n = this.getLocationOnScreen().x;
                int n2 = this.getLocationOnScreen().y;
                this.m_PD = new PropertyDialog(this.m_ClassifierEditor, n, n2);
            } else {
                this.m_PD.setVisible(true);
            }
            this.m_DeleteBut.setEnabled(true);
        } else if (actionEvent.getSource() == this.m_DeleteBut) {
            int n;
            int[] nArray = this.m_List.getSelectedIndices();
            if (nArray != null) {
                for (int i = nArray.length - 1; i >= 0; --i) {
                    n = nArray[i];
                    this.m_AlgorithmListModel.removeElementAt(n);
                    if (this.m_Exp.getDatasets().size() > n) {
                        this.m_List.setSelectedIndex(n);
                        continue;
                    }
                    this.m_List.setSelectedIndex(n - 1);
                }
            }
            if (this.m_List.getSelectedIndex() == -1) {
                this.m_DeleteBut.setEnabled(false);
            }
            Classifier[] classifierArray = new Classifier[this.m_AlgorithmListModel.size()];
            for (n = 0; n < classifierArray.length; ++n) {
                classifierArray[n] = (Classifier)this.m_AlgorithmListModel.elementAt(n);
            }
            this.m_Exp.setPropertyArray(classifierArray);
        }
    }

    protected Object copyObject(Object object) {
        Object object2 = null;
        try {
            SerializedObject serializedObject = new SerializedObject(object);
            object2 = serializedObject.getObject();
        }
        catch (Exception exception) {
            System.err.println("AlgorithmListPanel: Problem copying object");
            System.err.println(exception);
        }
        return object2;
    }

    public static void main(String[] stringArray) {
        try {
            final JFrame jFrame = new JFrame("Algorithm List Editor");
            jFrame.getContentPane().setLayout(new BorderLayout());
            AlgorithmListPanel algorithmListPanel = new AlgorithmListPanel();
            jFrame.getContentPane().add((Component)algorithmListPanel, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setVisible(true);
            System.err.println("Short nap");
            Thread.currentThread();
            Thread.sleep(3000L);
            System.err.println("Done");
            algorithmListPanel.setExperiment(new Experiment());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        PropertyEditorManager.registerEditor(class$weka$core$SelectedTag == null ? (class$weka$core$SelectedTag = AlgorithmListPanel.class$("weka.core.SelectedTag")) : class$weka$core$SelectedTag, class$weka$gui$SelectedTagEditor == null ? (class$weka$gui$SelectedTagEditor = AlgorithmListPanel.class$("weka.gui.SelectedTagEditor")) : class$weka$gui$SelectedTagEditor);
        PropertyEditorManager.registerEditor(class$weka$filters$Filter == null ? (class$weka$filters$Filter = AlgorithmListPanel.class$("weka.filters.Filter")) : class$weka$filters$Filter, class$weka$gui$GenericObjectEditor == null ? (class$weka$gui$GenericObjectEditor = AlgorithmListPanel.class$("weka.gui.GenericObjectEditor")) : class$weka$gui$GenericObjectEditor);
        PropertyEditorManager.registerEditor(array$Lweka$classifiers$Classifier == null ? (array$Lweka$classifiers$Classifier = AlgorithmListPanel.class$("[Lweka.classifiers.Classifier;")) : array$Lweka$classifiers$Classifier, class$weka$gui$GenericArrayEditor == null ? (class$weka$gui$GenericArrayEditor = AlgorithmListPanel.class$("weka.gui.GenericArrayEditor")) : class$weka$gui$GenericArrayEditor);
        PropertyEditorManager.registerEditor(array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = AlgorithmListPanel.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object, class$weka$gui$GenericArrayEditor == null ? (class$weka$gui$GenericArrayEditor = AlgorithmListPanel.class$("weka.gui.GenericArrayEditor")) : class$weka$gui$GenericArrayEditor);
        PropertyEditorManager.registerEditor(class$weka$classifiers$Classifier == null ? (class$weka$classifiers$Classifier = AlgorithmListPanel.class$("weka.classifiers.Classifier")) : class$weka$classifiers$Classifier, class$weka$gui$GenericObjectEditor == null ? (class$weka$gui$GenericObjectEditor = AlgorithmListPanel.class$("weka.gui.GenericObjectEditor")) : class$weka$gui$GenericObjectEditor);
        PropertyEditorManager.registerEditor(class$weka$associations$CARuleMiner == null ? (class$weka$associations$CARuleMiner = AlgorithmListPanel.class$("weka.associations.CARuleMiner")) : class$weka$associations$CARuleMiner, class$weka$gui$GenericObjectEditor == null ? (class$weka$gui$GenericObjectEditor = AlgorithmListPanel.class$("weka.gui.GenericObjectEditor")) : class$weka$gui$GenericObjectEditor);
        PropertyEditorManager.registerEditor(class$weka$classifiers$CostMatrix == null ? (class$weka$classifiers$CostMatrix = AlgorithmListPanel.class$("weka.classifiers.CostMatrix")) : class$weka$classifiers$CostMatrix, class$weka$gui$CostMatrixEditor == null ? (class$weka$gui$CostMatrixEditor = AlgorithmListPanel.class$("weka.gui.CostMatrixEditor")) : class$weka$gui$CostMatrixEditor);
    }

    public class ObjectCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            String string = object.getClass().getName();
            int n2 = string.lastIndexOf(46);
            if (n2 != -1) {
                string = string.substring(n2 + 1);
            }
            if (object instanceof OptionHandler) {
                string = string + " " + Utils.joinOptions(((OptionHandler)object).getOptions());
            }
            this.setText(string);
            return component;
        }
    }
}

