/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.auth;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.columba.ristretto.auth.AuthenticationMechanism;
import org.columba.ristretto.auth.NoSuchAuthenticationException;
import org.columba.ristretto.auth.mechanism.CramMD5Mechanism;
import org.columba.ristretto.auth.mechanism.DigestMD5Mechanism;
import org.columba.ristretto.auth.mechanism.LoginMechanism;
import org.columba.ristretto.auth.mechanism.PlainMechanism;
import org.columba.ristretto.auth.mechanism.SaslWrapper;

public class AuthenticationFactory {
    private static final Logger LOG = Logger.getLogger("org.columba.ristretto.auth");
    private static final Pattern authTokenizerPattern = Pattern.compile("\\b([^\\s]+)\\b");
    private Map authTable = new Hashtable();
    private static AuthenticationFactory myInstance;

    private AuthenticationFactory() {
        this.addAuthentication("PLAIN", PlainMechanism.class);
        this.addAuthentication("LOGIN", LoginMechanism.class);
        if (SaslWrapper.available()) {
            this.addAuthentication("DIGEST-MD5", DigestMD5Mechanism.class);
            this.addAuthentication("CRAM-MD5", CramMD5Mechanism.class);
        }
    }

    public static AuthenticationFactory getInstance() {
        if (myInstance == null) {
            myInstance = new AuthenticationFactory();
        }
        return myInstance;
    }

    public void addAuthentication(String name, Class auth) {
        this.authTable.put(name, auth);
    }

    public AuthenticationMechanism getAuthentication(String name) throws NoSuchAuthenticationException {
        AuthenticationMechanism auth;
        if (!this.authTable.containsKey(name)) {
            throw new NoSuchAuthenticationException(name);
        }
        try {
            auth = (AuthenticationMechanism)((Class)this.authTable.get(name)).newInstance();
        }
        catch (InstantiationException e) {
            throw new NoSuchAuthenticationException(e);
        }
        catch (IllegalAccessException e) {
            throw new NoSuchAuthenticationException(e);
        }
        return auth;
    }

    public boolean isSupported(String mechanism) {
        return this.authTable.get(mechanism) != null;
    }

    public List getSupportedMechanisms() {
        LinkedList list = new LinkedList();
        Set keys = this.authTable.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public List getSupportedMechanisms(String authCapa) {
        LinkedList<String> list = new LinkedList<String>();
        Matcher matcher = authTokenizerPattern.matcher(authCapa);
        matcher.find();
        while (matcher.find()) {
            if (!this.isSupported(matcher.group(1))) continue;
            list.add(matcher.group(1));
        }
        return list;
    }

    public String getSecurestMethod(String authCapability) throws NoSuchAuthenticationException {
        Matcher matcher = authTokenizerPattern.matcher(authCapability);
        matcher.find();
        while (matcher.find()) {
            if (!this.isSupported(matcher.group(1))) continue;
            return matcher.group(1);
        }
        throw new NoSuchAuthenticationException(authCapability);
    }
}

