/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.auth.mechanism;

import [Ljava.lang.String;;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;

public class SaslWrapper {
    private static final boolean JAVA_14 = System.getProperty("java.version").matches("1\\.4.*");
    private static final String PACKAGE_14 = "com.sun.security.sasl.preview.";
    private static final String PACKAGE_15 = "javax.security.sasl.";
    String packageString = JAVA_14 ? "com.sun.security.sasl.preview." : "javax.security.sasl.";
    Class saslClient = Class.forName(this.packageString + "SaslClient");
    Class sasl = Class.forName(this.packageString + "Sasl");
    Object saslClientInstance;

    public static boolean available() {
        if (JAVA_14) {
            try {
                Class.forName("com.sun.security.sasl.preview.Sasl");
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
        return true;
    }

    public void createClient(String[] type, String user, String service, String hostname, Map map, CallbackHandler handler) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        Method createSaslClient = this.sasl.getMethod("createSaslClient", String;.class, String.class, String.class, String.class, Map.class, CallbackHandler.class);
        this.saslClientInstance = createSaslClient.invoke(null, type, user, service, hostname, map, handler);
    }

    public byte[] evaluateChallenge(byte[] challenge) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method evaluateChallenge = this.saslClient.getMethod("evaluateChallenge", [B.class);
        Object result = evaluateChallenge.invoke(this.saslClientInstance, new Object[]{challenge});
        return (byte[])result;
    }

    public boolean isComplete() throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method evaluateChallenge = this.saslClient.getMethod("isComplete", new Class[0]);
        Boolean result = (Boolean)evaluateChallenge.invoke(this.saslClientInstance, new Object[0]);
        return result;
    }

    public boolean handle(Callback callback) {
        try {
            Class<?> realmCallback = Class.forName(this.packageString + "RealmCallback");
            if (realmCallback.equals(callback.getClass())) {
                Method setText = realmCallback.getMethod("setText", String.class);
                Method getDefaultText = realmCallback.getMethod("getDefaultText", new Class[0]);
                setText.invoke((Object)callback, getDefaultText.invoke((Object)callback, new Object[0]));
                return true;
            }
            Class<?> realmChoiceCallback = Class.forName(this.packageString + "RealmChoiceCallback");
            if (realmChoiceCallback.equals(callback.getClass())) {
                Method setSelectedIndex = realmChoiceCallback.getMethod("setSelectedIndex", Integer.TYPE);
                Method getDefaultChoice = realmChoiceCallback.getMethod("getDefaultChoice", new Class[0]);
                setSelectedIndex.invoke((Object)callback, getDefaultChoice.invoke((Object)callback, new Object[0]));
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }
}

