/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.coder;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class Base64 {
    private static final char[] etable = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static byte[] dtable = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 0, 0, 0, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 0, 0, 0, 0, 0, 0, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 0, 0, 0, 0, 0};

    public static ByteBuffer decode(CharSequence input) {
        int size = (int)((double)input.length() * 0.75);
        byte[] outBytes = new byte[size];
        byte[] pack = new byte[4];
        int outPos = 0;
        int packSize = 0;
        int pads = 0;
        for (int i = 0; i < input.length(); ++i) {
            char current = input.charAt(i);
            if (current != '\r' && current != '\n') {
                pack[packSize++] = (byte)current;
                if (current == '=') {
                    ++pads;
                }
            }
            if (packSize != 4) continue;
            outBytes[outPos++] = (byte)(dtable[pack[0]] << 2 | dtable[pack[1]] >> 4);
            if (pads < 2) {
                outBytes[outPos++] = (byte)(dtable[pack[1]] << 4 | dtable[pack[2]] >> 2);
            }
            if (pads < 1) {
                outBytes[outPos++] = (byte)(dtable[pack[2]] << 6 | dtable[pack[3]]);
            }
            packSize = 0;
            if (pads != 0) break;
        }
        return ByteBuffer.wrap(outBytes, 0, outPos);
    }

    public static byte[] decodeToArray(CharSequence input) {
        ByteBuffer buffer = Base64.decode(input);
        if (buffer.limit() == buffer.capacity()) {
            return buffer.array();
        }
        byte[] result = new byte[buffer.limit()];
        System.arraycopy(buffer.array(), 0, result, 0, buffer.limit());
        return result;
    }

    public static StringBuffer encode(ByteBuffer input, boolean wrap) {
        int i;
        int lastPackSize = input.limit() % 3;
        int estimatedEncodedSize = (int)((double)input.limit() * 1.333 + 0.5) + 2;
        StringBuffer result = new StringBuffer(estimatedEncodedSize + estimatedEncodedSize / 76 * 2);
        int packsPerLine = 0;
        for (i = 0; i < input.limit() - lastPackSize; i += 3) {
            result.append(etable[(byte)(0x3F & input.get(i) >> 2)]);
            result.append(etable[(byte)(0x3F & input.get(i) << 4 | 0xF & input.get(i + 1) >> 4)]);
            result.append(etable[(byte)(0x3F & input.get(i + 1) << 2 | 3 & input.get(i + 2) >> 6)]);
            result.append(etable[(byte)(0x3F & input.get(i + 2))]);
            if (++packsPerLine != 25 || !wrap) continue;
            result.append("\r\n");
            packsPerLine = 0;
        }
        if (lastPackSize == 2) {
            result.append(etable[(byte)(0x3F & input.get(i) >> 2)]);
            result.append(etable[(byte)(0x3F & input.get(i) << 4 | 0xF & input.get(i + 1) >> 4)]);
            result.append(etable[(byte)(0x3F & input.get(i + 1) << 2)]);
            result.append('=');
        }
        if (lastPackSize == 1) {
            result.append(etable[(byte)(0x3F & input.get(i) >> 2)]);
            result.append(etable[(byte)(0x3F & input.get(i) << 4)]);
            result.append('=');
            result.append('=');
        }
        return result;
    }

    public static StringBuffer encode(String input) {
        Charset charset = Charset.forName("US-ASCII");
        ByteBuffer bytes = charset.encode(input);
        return Base64.encode(bytes);
    }

    public static StringBuffer encode(ByteBuffer buffer) {
        return Base64.encode(buffer, true);
    }
}

