/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.coder;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.columba.ristretto.coder.CRLFFilterInputStream;

public class Base64DecoderInputStream
extends FilterInputStream {
    private static byte[] table = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 0, 0, 0, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 0, 0, 0, 0, 0, 0, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 0, 0, 0, 0, 0};
    private int[] outBytes = new int[3];
    private byte[] inBytes = new byte[4];
    private int pos;
    private int available;

    public Base64DecoderInputStream(InputStream in) {
        super(new CRLFFilterInputStream(in));
    }

    private int readNextPack() throws IOException {
        int[] lookedUp = new int[4];
        int read = this.in.read(this.inBytes);
        if (read != 4) {
            return -1;
        }
        lookedUp[0] = table[this.inBytes[0]];
        lookedUp[1] = table[this.inBytes[1]];
        lookedUp[2] = table[this.inBytes[2]];
        lookedUp[3] = table[this.inBytes[3]];
        this.outBytes[0] = 0xFF & (lookedUp[0] << 2 | lookedUp[1] >> 4);
        this.outBytes[1] = 0xFF & (lookedUp[1] << 4 | lookedUp[2] >> 2);
        this.outBytes[2] = 0xFF & (lookedUp[2] << 6 | lookedUp[3]);
        if (this.inBytes[2] == 61) {
            return 1;
        }
        if (this.inBytes[3] == 61) {
            return 2;
        }
        return 3;
    }

    public int read() throws IOException {
        if (this.pos == this.available) {
            this.available = this.readNextPack();
            this.pos = 0;
        }
        if (this.available == -1) {
            return -1;
        }
        return this.outBytes[this.pos++];
    }

    public int read(byte[] arg0, int arg1, int arg2) throws IOException {
        for (int i = 0; i < arg2; ++i) {
            int next = this.read();
            if (next == -1) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            arg0[arg1 + i] = (byte)next;
        }
        return arg2;
    }
}

