/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.coder;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class CharsetEncoderInputStream
extends FilterInputStream {
    private Charset charset;
    private CharsetEncoder encoder;
    private CharBuffer inBytes;
    private ByteBuffer outBytes;
    private int pos;
    private int available;

    public CharsetEncoderInputStream(InputStream arg0, Charset charset) {
        super(arg0);
        this.charset = charset;
        this.encoder = charset.newEncoder();
        this.inBytes = CharBuffer.allocate(1);
        this.outBytes = ByteBuffer.allocate(5);
    }

    private int encodeNextCharacter() throws IOException {
        int read = this.in.read();
        if (read == -1) {
            return -1;
        }
        this.inBytes.clear();
        this.inBytes.put(0, (char)read);
        this.outBytes.clear();
        CoderResult result = this.encoder.encode(this.inBytes, this.outBytes, this.in.available() == 0);
        if (result.isMalformed() || result.isUnmappable()) {
            this.outBytes.put((byte)0);
            return this.outBytes.limit();
        }
        return this.outBytes.position();
    }

    public int read() throws IOException {
        if (this.pos == this.available) {
            this.available = this.encodeNextCharacter();
            this.pos = 0;
        }
        if (this.available == -1) {
            return -1;
        }
        return this.outBytes.get(this.pos++);
    }

    public int read(byte[] arg0, int arg1, int arg2) throws IOException {
        for (int i = 0; i < arg2; ++i) {
            int next = this.read();
            if (next == -1) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            arg0[arg1 + i] = (byte)next;
        }
        return arg2;
    }
}

