/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.coder;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Hashtable;

public class FallbackCharsetDecoderInputStream
extends FilterInputStream {
    private Charset charset;
    private CharsetDecoder decoder;
    private ByteBuffer inBytes;
    private CharBuffer outChars;
    private static Hashtable fallbackTable = FallbackCharsetDecoderInputStream.initFallBackTable();

    public FallbackCharsetDecoderInputStream(InputStream arg0, Charset charset) {
        super(arg0);
        this.charset = charset;
        this.initDecoder();
        this.inBytes = ByteBuffer.allocate(5);
        this.outChars = CharBuffer.allocate(1);
    }

    private static Hashtable initFallBackTable() {
        Hashtable<Charset, Charset> table = new Hashtable<Charset, Charset>();
        table.put(Charset.forName("iso-8859-15"), Charset.forName("windows-1252"));
        table.put(Charset.forName("iso-8859-1"), Charset.forName("windows-1252"));
        table.put(Charset.forName("us-ascii"), Charset.forName("windows-1252"));
        return table;
    }

    public static void addFallback(Charset original, Charset fallback) {
        fallbackTable.put(original, fallback);
    }

    private int decodeNextChar() throws IOException {
        this.inBytes.clear();
        this.inBytes.limit(1);
        int read = this.in.read();
        if (read == -1) {
            return -1;
        }
        this.inBytes.put(0, (byte)read);
        this.outChars.clear();
        CoderResult result = this.decoder.decode(this.inBytes, this.outChars, this.in.available() == 0);
        if (this.outChars.position() == 0) {
            read = this.in.read();
            if (read == -1) {
                return -1;
            }
            this.inBytes.limit(this.inBytes.limit() + 1);
            this.inBytes.put(this.inBytes.limit() - 1, (byte)read);
            this.outChars.clear();
            result = this.decoder.decode(this.inBytes, this.outChars, this.in.available() == 0);
        }
        ByteBuffer test = this.charset.encode(this.outChars);
        while (test.capacity() == 0 && this.fallback()) {
            this.inBytes.rewind();
            this.outChars.clear();
            result = this.decoder.decode(this.inBytes, this.outChars, this.in.available() == 0);
            test = this.charset.encode(this.outChars);
        }
        return this.outChars.position();
    }

    private boolean fallback() {
        if (fallbackTable.containsKey(this.charset)) {
            this.charset = (Charset)fallbackTable.get(this.charset);
            this.initDecoder();
            return true;
        }
        return false;
    }

    private void initDecoder() {
        this.decoder = this.charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    public int read() throws IOException {
        if (this.decodeNextChar() == -1) {
            return -1;
        }
        return this.outChars.get(0);
    }

    public int read(byte[] arg0, int arg1, int arg2) throws IOException {
        for (int i = 0; i < arg2; ++i) {
            int next = this.read();
            if (next == -1) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            arg0[arg1 + i] = (byte)next;
        }
        return arg2;
    }
}

