/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.coder;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.IntBuffer;

public class QuotedPrintableEncoderInputStream
extends FilterInputStream {
    private static final char[] hexTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private IntBuffer outBytes = IntBuffer.allocate(10);
    private int pos;
    private int available;
    private int lineLength;

    public QuotedPrintableEncoderInputStream(InputStream arg0) {
        super(arg0);
    }

    private int processNextInput() throws IOException {
        this.outBytes.clear();
        int read = this.in.read();
        if (read == -1) {
            return -1;
        }
        if (read == 9 || read == 32) {
            if (this.lineLength >= 74) {
                this.outBytes.put(61);
                this.outBytes.put(this.toHexString(read));
                this.lineLength += 3;
            } else {
                int next = this.in.read();
                if (next != -1) {
                    if (next == 13 || next == 10) {
                        this.outBytes.put(61);
                        this.outBytes.put(this.toHexString(read));
                        this.lineLength += 3;
                    } else {
                        this.outBytes.put(read);
                        ++this.lineLength;
                    }
                    read = next;
                }
            }
        }
        if (read >= 33 && read != 61 && read <= 126) {
            this.outBytes.put(read);
            ++this.lineLength;
        } else if (read == 13) {
            this.outBytes.put(13);
            this.outBytes.put(10);
            this.in.read();
            this.lineLength = 0;
        } else if (read == 10) {
            this.outBytes.put(13);
            this.outBytes.put(10);
            this.lineLength = 0;
        } else {
            this.outBytes.put(61);
            this.outBytes.put(this.toHexString(read));
            this.lineLength += 3;
        }
        if (this.lineLength >= 74) {
            this.outBytes.put(61);
            this.outBytes.put(13);
            this.outBytes.put(10);
            this.lineLength = 0;
        }
        return this.outBytes.position();
    }

    public int read() throws IOException {
        if (this.pos == this.available) {
            this.available = this.processNextInput();
            this.pos = 0;
        }
        if (this.available == -1) {
            return -1;
        }
        return this.outBytes.get(this.pos++);
    }

    public int read(byte[] arg0, int arg1, int arg2) throws IOException {
        for (int i = 0; i < arg2; ++i) {
            int next = this.read();
            if (next == -1) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            arg0[arg1 + i] = (byte)next;
        }
        return arg2;
    }

    private int[] toHexString(int in) {
        int[] result = new int[2];
        int value = in < 0 ? 0x80 | 0x7F & in : in;
        int hi = value / 16;
        int lo = value % 16;
        result[0] = hexTable[hi];
        result[1] = hexTable[lo];
        return result;
    }
}

