/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.columba.ristretto.concurrency.Semaphore;

public class AsyncInputStream
extends FilterInputStream {
    private Semaphore semaphore = new Semaphore();
    private IOException exception;
    private int size;
    private int read;

    public AsyncInputStream(InputStream source, int size) {
        super(source);
        this.size = size;
        this.read = 0;
    }

    public int read() throws IOException {
        if (this.read < this.size) {
            this.semaphore.acquire();
            if (this.exception != null) {
                throw this.exception;
            }
            if (this.read < this.size) {
                ++this.read;
                return super.read();
            }
            return -1;
        }
        return -1;
    }

    public void exceptionOccured(IOException e) {
        this.exception = e;
    }

    public void grow(int size) {
        this.semaphore.release(size);
    }

    public int read(byte[] arg0, int arg1, int arg2) throws IOException {
        for (int i = 0; i < arg2; ++i) {
            int next = this.read();
            if (next == -1) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            arg0[arg1 + i] = (byte)next;
        }
        return arg2;
    }

    public int available() throws IOException {
        return this.size - this.read;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }
}

