/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.io;

import java.io.IOException;
import java.util.ArrayList;
import org.columba.ristretto.io.Source;

public class ConcatenatedSource
implements Source {
    ArrayList sources = new ArrayList();
    ArrayList nextSourceBegin = new ArrayList();
    int position;
    int length;
    int sourceIndex;

    public ConcatenatedSource() {
        this.nextSourceBegin.add(new Integer(0));
        this.position = 0;
        this.length = 0;
        this.sourceIndex = 0;
    }

    public void addSource(Source source) {
        this.sources.add(source);
        this.length += source.length();
        this.nextSourceBegin.add(new Integer(this.length));
    }

    public Source fromActualPosition() {
        ConcatenatedSource newsource = new ConcatenatedSource();
        newsource.addSource(((Source)this.sources.get(this.sourceIndex)).fromActualPosition());
        for (int i = this.sourceIndex + 1; i < this.sources.size(); ++i) {
            newsource.addSource((Source)this.sources.get(i));
        }
        return newsource;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean isEOF() {
        return this.position == this.length;
    }

    public char next() throws IOException {
        if (((Source)this.sources.get(this.sourceIndex)).isEOF()) {
            ++this.sourceIndex;
        }
        return ((Source)this.sources.get(this.sourceIndex)).next();
    }

    public void seek(int arg0) throws IOException {
        if ((Integer)this.nextSourceBegin.get(this.sourceIndex) >= arg0 || arg0 >= (Integer)this.nextSourceBegin.get(this.sourceIndex + 1)) {
            this.sourceIndex = 0;
            while ((Integer)this.nextSourceBegin.get(this.sourceIndex) > arg0 || arg0 >= (Integer)this.nextSourceBegin.get(this.sourceIndex + 1)) {
                ++this.sourceIndex;
            }
        }
        int posInSource = arg0 - (Integer)this.nextSourceBegin.get(this.sourceIndex);
        this.position = arg0;
        ((Source)this.sources.get(this.sourceIndex)).seek(posInSource);
    }

    public char charAt(int arg0) {
        try {
            this.seek(arg0);
        }
        catch (IOException e) {
            return '\u0000';
        }
        return ((Source)this.sources.get(this.sourceIndex)).charAt(((Source)this.sources.get(this.sourceIndex)).getPosition());
    }

    public int length() {
        return this.length;
    }

    public CharSequence subSequence(int arg0, int arg1) {
        if (arg1 - arg0 < 1024) {
            StringBuffer result = new StringBuffer(arg1 - arg0);
            for (int i = arg0; i < arg1; ++i) {
                result.append(this.charAt(i));
            }
            return result;
        }
        return this.subSource(arg0, arg1);
    }

    public Source subSource(int arg0, int arg1) {
        ConcatenatedSource newsource = new ConcatenatedSource();
        int beginSourceIndex = 0;
        while ((Integer)this.nextSourceBegin.get(beginSourceIndex) > arg0 || arg0 >= (Integer)this.nextSourceBegin.get(beginSourceIndex + 1)) {
            ++beginSourceIndex;
        }
        int beginPos = arg0 - (Integer)this.nextSourceBegin.get(beginSourceIndex);
        int endSourceIndex = 0;
        while ((Integer)this.nextSourceBegin.get(endSourceIndex) > arg1 || arg1 >= (Integer)this.nextSourceBegin.get(endSourceIndex + 1)) {
            ++endSourceIndex;
        }
        int endPos = arg1 - (Integer)this.nextSourceBegin.get(endSourceIndex);
        if (beginSourceIndex == endSourceIndex) {
            newsource.addSource((Source)((Source)this.sources.get(beginSourceIndex)).subSequence(beginPos, endPos));
        } else {
            newsource.addSource((Source)((Source)this.sources.get(beginSourceIndex)).subSequence(beginPos, ((Source)this.sources.get(beginSourceIndex)).length()));
            for (int i = beginSourceIndex + 1; i < endSourceIndex - 1; ++i) {
                newsource.addSource((Source)this.sources.get(i));
            }
            newsource.addSource((Source)((Source)this.sources.get(endSourceIndex)).subSequence(0, endPos));
        }
        return newsource;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.length);
        for (int i = 0; i < this.sources.size(); ++i) {
            result.append(this.sources.get(i).toString());
        }
        return result.toString();
    }

    public void close() throws IOException {
        for (int i = 0; i < this.sources.size(); ++i) {
            ((Source)this.sources.get(i)).close();
        }
        this.sources = null;
    }

    public void deepClose() throws IOException {
        for (int i = 0; i < this.sources.size(); ++i) {
            ((Source)this.sources.get(i)).deepClose();
        }
        this.sources = null;
    }
}

