/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.io;

import java.io.File;
import java.io.IOException;
import org.columba.ristretto.io.FileSourceModel;
import org.columba.ristretto.io.Source;

public class FileSource
implements Source {
    private int start;
    private int end;
    private int pos;
    private FileSourceModel model;

    public FileSource(File file) throws IOException {
        this.model = new FileSourceModel(file);
        this.model.incReferences();
        this.start = 0;
        this.end = this.model.length();
        this.pos = 0;
    }

    protected FileSource(FileSource parent) {
        this.model = parent.model;
        this.model.incReferences();
        this.start = parent.start;
        this.end = parent.end;
        this.pos = 0;
    }

    public Source fromActualPosition() {
        FileSource subsource = new FileSource(this);
        subsource.start = this.start + this.pos;
        return subsource;
    }

    public int getPosition() {
        return this.pos;
    }

    public void seek(int position) throws IOException {
        this.pos = position;
    }

    public char next() throws IOException {
        return this.model.get(this.start + this.pos++);
    }

    public int length() {
        return this.end - this.start;
    }

    public char charAt(int arg0) {
        try {
            return this.model.get(this.start + arg0);
        }
        catch (IOException e) {
            e.printStackTrace();
            return '\u0000';
        }
    }

    public Source subSource(int arg0, int arg1) {
        FileSource subsource = new FileSource(this);
        subsource.start = this.start + arg0;
        subsource.end = this.start + arg1;
        return subsource;
    }

    public CharSequence subSequence(int arg0, int arg1) {
        if (arg1 - arg0 < 1024) {
            StringBuffer result = new StringBuffer(arg1 - arg0);
            for (int i = arg0; i < arg1; ++i) {
                result.append(this.charAt(i));
            }
            return result;
        }
        return this.subSource(arg0, arg1);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.length());
        for (int i = 0; i < this.length(); ++i) {
            buffer.append(this.charAt(i));
        }
        return buffer.toString();
    }

    public boolean isEOF() {
        return this.pos == this.end;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.model != null) {
            this.model.decReferences();
            this.model = null;
        }
    }

    public void close() throws IOException {
        if (this.model != null) {
            this.model.decReferences();
            this.model = null;
        }
    }

    public void deepClose() throws IOException {
        if (this.model != null) {
            this.model.close();
        }
        this.model = null;
    }

    public File getFile() {
        return this.model.getFile();
    }
}

