/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class SequenceInputStream
extends InputStream {
    List streams;
    int index;

    public SequenceInputStream(List e) {
        this.streams = e;
    }

    public SequenceInputStream(InputStream s1, InputStream s2) {
        this.streams = Arrays.asList(s1, s2);
    }

    public int read() throws IOException {
        int read = ((InputStream)this.streams.get(this.index)).read();
        if (read == -1 && this.index < this.streams.size() - 1) {
            ++this.index;
            read = ((InputStream)this.streams.get(this.index)).read();
        }
        return read;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read = ((InputStream)this.streams.get(this.index)).read(b, off, len);
        while (read != len && this.index < this.streams.size() - 1) {
            if (read == -1) {
                read = 0;
            }
            ++this.index;
            int nextread = ((InputStream)this.streams.get(this.index)).read(b, off + read, len - read);
            if (nextread == -1) continue;
            read += nextread;
        }
        return read;
    }

    public int available() throws IOException {
        int size = 0;
        for (int i = 0; i < this.streams.size(); ++i) {
            size += ((InputStream)this.streams.get(i)).available();
        }
        return size;
    }

    public void close() throws IOException {
        Iterator it = this.streams.iterator();
        while (it.hasNext()) {
            ((InputStream)it.next()).close();
        }
    }
}

