/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;

public class StreamUtils {
    private static final Logger LOG = Logger.getLogger("org.columba.ristretto.message.io");
    private static final int BUFFERSIZE = 8000;

    public static long streamCopy(InputStream _isInput, OutputStream _osOutput, int _iBufSize) throws IOException {
        int _iBytesRead;
        byte[] _aBuffer = new byte[_iBufSize];
        long _lBytesCopied = 0L;
        while ((_iBytesRead = _isInput.read(_aBuffer)) > 0) {
            _osOutput.write(_aBuffer, 0, _iBytesRead);
            _lBytesCopied += (long)_iBytesRead;
            _osOutput.flush();
        }
        LOG.finer("Copied " + _lBytesCopied + "bytes");
        return _lBytesCopied;
    }

    public static long streamCopy(InputStream _isInput, OutputStream _osOutput) throws IOException {
        return StreamUtils.streamCopy(_isInput, _osOutput, 8000);
    }

    public static StringBuffer readInString(InputStream in) throws IOException {
        StringBuffer result = new StringBuffer(in.available());
        int read = in.read();
        while (read > 0) {
            result.append((char)read);
            read = in.read();
        }
        in.close();
        return result;
    }

    public static InputStream streamClone(InputStream from) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamUtils.streamCopy(from, out);
        return new ByteArrayInputStream(out.toByteArray());
    }
}

