/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.columba.ristretto.io.ByteBufferSource;
import org.columba.ristretto.io.FileSource;
import org.columba.ristretto.io.Source;

public class TempSourceFactory {
    public static int MAX_IN_RAM_SIZE = 51200;
    protected static String TEMP_PREFIX = "ristretto_";
    protected static String TEMP_POSTFIX = "tmp";
    protected static int BUFFER_SIZE = 51200;
    private static int counter = 0;

    public static Source createTempSource(InputStream in, int size) throws IOException {
        if (size != -1 && (size < MAX_IN_RAM_SIZE || in.available() < MAX_IN_RAM_SIZE)) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            TempSourceFactory.copyStream(in, out, size);
            out.close();
            return new ByteBufferSource(out.toByteArray());
        }
        File tempFile = TempSourceFactory.createTempFile();
        FileOutputStream out = new FileOutputStream(tempFile);
        TempSourceFactory.copyStream(in, out, size);
        ((OutputStream)out).close();
        return new FileSource(tempFile);
    }

    public static Source createTempSource(InputStream in) throws IOException {
        return TempSourceFactory.createTempSource(in, -1);
    }

    public static boolean useMemoryTemp(int size) {
        return size < MAX_IN_RAM_SIZE;
    }

    public static File createTempFile() throws IOException {
        File tempFile = File.createTempFile(TEMP_PREFIX + TempSourceFactory.nextID(), TEMP_POSTFIX);
        tempFile.deleteOnExit();
        return tempFile;
    }

    private static synchronized int nextID() {
        return counter++;
    }

    private static int copyStream(InputStream in, OutputStream out, int size) throws IOException {
        byte[] buffer = new byte[BUFFER_SIZE];
        int copied = 0;
        if (size != -1) {
            int actSize;
            while (size - copied > 0 && (actSize = in.read(buffer, 0, size - copied >= BUFFER_SIZE ? BUFFER_SIZE : size - copied)) != -1) {
                out.write(buffer, 0, actSize);
                copied += actSize;
            }
        } else {
            int actSize;
            while ((actSize = in.read(buffer)) != -1) {
                out.write(buffer, 0, actSize);
                copied += actSize;
            }
        }
        return copied;
    }
}

