/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.message;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.columba.ristretto.message.Saveable;

public class Attributes
implements Saveable,
Cloneable {
    private Hashtable attributes;

    public Attributes() {
        this.attributes = new Hashtable();
    }

    public Attributes(ObjectInputStream in) throws IOException {
        this.load(in);
    }

    public void put(String key, Object value) {
        this.attributes.put(key, value);
    }

    public Object get(String key) {
        return this.attributes.get(key);
    }

    public final void load(ObjectInputStream in) throws IOException {
        int size = in.readInt();
        this.attributes = new Hashtable(size);
        for (int i = 0; i < size; ++i) {
            try {
                this.attributes.put(in.readUTF(), in.readObject());
                continue;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public final void save(ObjectOutputStream out) throws IOException {
        out.writeInt(this.attributes.size());
        Iterator keys = this.attributes.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = this.attributes.get(key);
            out.writeUTF(key);
            out.writeObject(value);
        }
    }

    public int count() {
        return this.attributes.size();
    }

    public Object clone() {
        try {
            Attributes clone = (Attributes)super.clone();
            clone.attributes = (Hashtable)this.attributes.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj != null && obj instanceof Attributes) {
            Attributes other = (Attributes)obj;
            isEqual = this.attributes.equals(other.attributes);
        }
        return isEqual;
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Attributes[");
        Set set = this.attributes.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            buffer.append(key);
            buffer.append("=");
            buffer.append(this.attributes.get(key));
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("]");
        return buffer.toString();
    }
}

