/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.message;

import java.nio.charset.Charset;
import java.util.Date;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.columba.ristretto.coder.EncodedWord;
import org.columba.ristretto.message.Address;
import org.columba.ristretto.message.Header;
import org.columba.ristretto.message.MessageDate;
import org.columba.ristretto.parser.AddressParser;
import org.columba.ristretto.parser.DateParser;
import org.columba.ristretto.parser.ParserException;

public class BasicHeader {
    public static final int HIGHEST = 5;
    public static final int HIGH = 4;
    public static final int NORMAL = 3;
    public static final int LOW = 2;
    public static final int LOWEST = 1;
    private static final Pattern whiteSpaceTokenizer = Pattern.compile("\\s*([^\\s]+)");
    private Header header;
    private static final int PLAIN = 0;
    private static final int QUOTED = 1;
    private static final int COMMENT = 2;

    public BasicHeader(Header header) {
        this.header = header;
    }

    public Address getFrom() {
        return this.getAddress(this.header.get("From"));
    }

    public Address getBeenThere() {
        Address result = this.getAddress(this.header.get("X-BeenThere"));
        if (result == null) {
            result = this.getAddress(this.header.get("X-Beenthere"));
        }
        return result;
    }

    public Address[] getTo() {
        return this.getMailboxlist(this.header.get("To"));
    }

    public Address[] getCc() {
        return this.getMailboxlist(this.header.get("Cc"));
    }

    public Address[] getBcc() {
        return this.getMailboxlist(this.header.get("Bcc"));
    }

    public Address[] getReplyTo() {
        return this.getMailboxlist(this.header.get("Reply-To"));
    }

    public String getSubject() {
        String subject = this.header.get("Subject");
        if (subject != null) {
            return EncodedWord.decode(subject).toString();
        }
        return null;
    }

    public String getMessageID() {
        return this.header.get("Message-ID");
    }

    public String[] getReferences() {
        String references = this.header.get("References");
        return this.getWhitespaceSeparatedList(references);
    }

    public String[] getInReplyTo() {
        String references = this.header.get("In-Reply-To");
        return this.getWhitespaceSeparatedList(references);
    }

    public int getPriority() {
        String priority = this.header.get("X-Priority");
        if (priority != null) {
            try {
                return Integer.parseInt(priority);
            }
            catch (NumberFormatException e) {
                return 3;
            }
        }
        return 3;
    }

    public Date getDate() {
        String date = this.header.get("Date");
        if (date != null) {
            try {
                return DateParser.parse(BasicHeader.removeComments(date));
            }
            catch (ParserException e) {
                return new Date();
            }
        }
        return new Date();
    }

    public void setFrom(Address address) {
        this.header.set("From", address.toString());
    }

    public void setTo(Address[] addresses) {
        this.setAddressList(addresses, "To");
    }

    public void setCc(Address[] addresses) {
        this.setAddressList(addresses, "Cc");
    }

    public void setBcc(Address[] addresses) {
        this.setAddressList(addresses, "Bcc");
    }

    public void setReplyTo(Address[] addresses) {
        this.setAddressList(addresses, "Reply-To");
    }

    public void setDate(Date date) {
        this.header.set("Date", MessageDate.toString(date));
    }

    public void setMessageID(String messageid) {
        this.header.set("Message-ID", messageid);
    }

    public void setReferences(String[] messageids) {
        this.setMessageIDList("References", messageids);
    }

    public void setInReplyTo(String[] messageids) {
        this.setMessageIDList("In-Reply-To", messageids);
    }

    public void setPriority(int priority) {
        this.header.set("X-Priority", Integer.toString(priority));
    }

    public void setSubject(String subject, Charset charset) {
        this.header.set("Subject", EncodedWord.encode(subject, charset, 0));
    }

    private void setMessageIDList(String key, String[] messageids) {
        StringBuffer field = new StringBuffer(messageids[0]);
        for (int i = 1; i < messageids.length; ++i) {
            field.append(' ');
            field.append(messageids[i]);
        }
        this.header.set(key, EncodedWord.encode(field, Charset.forName("UTF-8"), 0).toString());
    }

    private void setAddressList(Address[] addresses, String fieldKey) {
        StringBuffer addressfield = new StringBuffer(addresses[0].toString());
        for (int i = 1; i < addresses.length; ++i) {
            addressfield.append(", ");
            addressfield.append(addresses[i].toString());
        }
        this.header.set(fieldKey, addressfield.toString());
    }

    private String[] getWhitespaceSeparatedList(String references) {
        if (references != null) {
            LinkedList<String> referenceList = new LinkedList<String>();
            Matcher matcher = whiteSpaceTokenizer.matcher(references);
            while (matcher.matches()) {
                referenceList.add(matcher.group(1));
            }
            String[] result = new String[referenceList.size()];
            referenceList.toArray((Object[])result);
            return result;
        }
        return new String[0];
    }

    private Address[] getMailboxlist(String from) {
        if (from != null) {
            try {
                return AddressParser.parseMailboxList(EncodedWord.decode(BasicHeader.removeComments(from)));
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
        }
        return new Address[0];
    }

    private Address getAddress(String from) {
        if (from != null) {
            try {
                return AddressParser.parseAddress(EncodedWord.decode(BasicHeader.removeComments(from)));
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public int count() {
        return this.header.count();
    }

    public String get(String key) {
        return this.header.get(key);
    }

    public void set(String key, Object value) {
        this.header.set(key, value);
    }

    public static final String removeComments(String value) {
        StringBuffer result = new StringBuffer(value.length());
        int state = 0;
        int depth = 0;
        block5: for (int i = 0; i < value.length(); ++i) {
            char current = value.charAt(i);
            switch (current) {
                case '\"': {
                    if (state == 2) continue block5;
                    state = state == 1 ? 0 : 1;
                    result.append(current);
                    continue block5;
                }
                case '(': {
                    if (state == 1) {
                        result.append(current);
                        continue block5;
                    }
                    if (state == 2) {
                        ++depth;
                        continue block5;
                    }
                    state = 2;
                    depth = 1;
                    continue block5;
                }
                case ')': {
                    if (state == 1) {
                        result.append(current);
                        continue block5;
                    }
                    if (state == 2) {
                        if (--depth != 0) continue block5;
                        state = 0;
                        continue block5;
                    }
                    result.append(current);
                    continue block5;
                }
                default: {
                    if (state == 2) continue block5;
                    result.append(current);
                }
            }
        }
        return result.toString();
    }
}

