/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.message;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.columba.ristretto.io.CharSequenceSource;
import org.columba.ristretto.io.SourceInputStream;
import org.columba.ristretto.io.Streamable;

public class Header
implements Streamable {
    private static final int MAXLINELENGTH = 78;
    private Hashtable header = new Hashtable();
    private static final String[] unlimitedFields = new String[]{"received", "x-"};

    public void set(String key, Object value) {
        if (value instanceof String) {
            this.header.put(key, value);
        } else {
            this.header.put(key, value.toString());
        }
    }

    public void append(String key, String value) {
        String oldvalue = (String)this.header.get(key);
        if (oldvalue == null || !Header.isUnlimited(key)) {
            this.header.put(key, value);
        } else {
            this.header.put(key, oldvalue + value);
        }
    }

    public String get(String key) {
        return (String)this.header.get(key);
    }

    public int length() {
        return this.header.size();
    }

    public Object clone() {
        Header cloneHeader = new Header();
        cloneHeader.header = (Hashtable)this.header.clone();
        return cloneHeader;
    }

    public int count() {
        return this.header.size();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        Enumeration keys = this.header.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            result.append(key);
            result.append(": ");
            result.append((Object)this.foldLine(this.get(key), 78 - key.length() - 2));
            result.append("\r\n");
        }
        result.append("\r\n");
        return result.toString();
    }

    public void merge(Header arg) {
        Enumeration keys = arg.header.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            this.header.put(key, arg.header.get(key));
        }
    }

    private CharSequence foldLine(String line, int firstMaxLength) {
        if (line.length() <= firstMaxLength || firstMaxLength <= 0) {
            return line;
        }
        int foldPos = line.indexOf(32, firstMaxLength);
        if (foldPos == -1) {
            return line;
        }
        StringBuffer result = new StringBuffer(line.length() + 3);
        result.append((Object)line.subSequence(0, foldPos));
        result.append("\r\n ");
        int lastFoldPos = foldPos;
        if ((foldPos += 78) < line.length()) {
            foldPos = line.indexOf(32, foldPos);
        }
        while (foldPos != -1 && foldPos < line.length()) {
            result.append((Object)line.subSequence(0, foldPos));
            result.append("\r\n ");
            lastFoldPos = foldPos;
            if ((foldPos += 78) >= line.length()) continue;
            foldPos = line.indexOf(32, foldPos);
        }
        result.append(line.substring(lastFoldPos));
        return result;
    }

    public InputStream getInputStream() {
        return new SourceInputStream(new CharSequenceSource(this.toString()));
    }

    public Enumeration getKeys() {
        return this.header.keys();
    }

    private static boolean isUnlimited(String key) {
        String ignoredCase = key.toLowerCase();
        for (int i = 0; i < unlimitedFields.length; ++i) {
            if (!ignoredCase.startsWith(unlimitedFields[i])) continue;
            return true;
        }
        return false;
    }
}

