/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.message;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class MessageDate {
    private static final String[] dayOfWeek = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static final String[] month = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    public static final String toString(Date date) {
        return MessageDate.toString(date, TimeZone.getDefault());
    }

    public static final String toString(Date date, TimeZone tz) {
        Calendar calendar = Calendar.getInstance(tz);
        calendar.setTime(date);
        StringBuffer result = new StringBuffer(31);
        result.append(dayOfWeek[calendar.get(7) - 1]);
        result.append(", ");
        result.append(calendar.get(5));
        result.append(' ');
        result.append(month[calendar.get(2)]);
        result.append(' ');
        result.append(calendar.get(1));
        result.append(' ');
        int hour = calendar.get(11);
        if (hour < 10) {
            result.append('0');
        }
        result.append(hour);
        result.append(':');
        int min = calendar.get(12);
        if (min < 10) {
            result.append('0');
        }
        result.append(min);
        result.append(':');
        int sec = calendar.get(13);
        if (sec < 10) {
            result.append('0');
        }
        result.append(sec);
        result.append(' ');
        int rawOffset = calendar.get(15) + calendar.get(16);
        if (rawOffset < 0) {
            int hours = -rawOffset / 3600000;
            int minutes = -rawOffset % 3600000 / 60000;
            result.append("-");
            if (hours < 10) {
                result.append('0');
            }
            result.append(hours);
            if (minutes < 10) {
                result.append('0');
            }
            result.append(minutes);
        } else {
            int hours = rawOffset / 3600000;
            int minutes = rawOffset % 3600000 / 60000;
            result.append("+");
            if (hours < 10) {
                result.append('0');
            }
            result.append(hours);
            if (minutes < 10) {
                result.append('0');
            }
            result.append(minutes);
        }
        return result.toString();
    }
}

