/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.message;

import java.util.List;
import java.util.Vector;
import org.columba.ristretto.message.MimeHeader;

public class MimePart {
    private List childs;
    private MimePart parent;
    protected MimeHeader header;
    protected int size;

    public MimePart() {
        this(new MimeHeader());
    }

    public MimePart(MimeHeader header) {
        this.header = header;
        this.childs = new Vector();
    }

    public Integer[] getAddress() {
        Vector<Integer> result = new Vector<Integer>();
        if (this.parent == null) {
            result.add(new Integer(0));
        } else {
            MimePart nextChild = this;
            for (MimePart nextParent = this.parent; nextParent != null; nextParent = nextParent.getParent()) {
                result.add(0, new Integer(nextParent.getNumber(nextChild)));
                nextChild = nextParent;
            }
        }
        Integer[] returnValue = new Integer[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            returnValue[i] = (Integer)result.get(i);
        }
        return returnValue;
    }

    public MimePart getParent() {
        return this.parent;
    }

    public void setParent(MimePart parent) {
        this.parent = parent;
    }

    public int countChilds() {
        return this.childs.size();
    }

    public MimePart getChild(int nr) {
        return (MimePart)this.childs.get(nr);
    }

    public void addChild(MimePart child) {
        if (child == null) {
            return;
        }
        this.childs.add(child);
        child.setParent(this);
    }

    public int count() {
        if (this.header.getMimeType().getSubtype().equals("alternative")) {
            return 1;
        }
        if (this.countChilds() == 0) {
            return 1;
        }
        int result = 0;
        for (int i = 0; i < this.countChilds(); ++i) {
            result += this.getChild(i).count();
        }
        return result;
    }

    public int getNumber(MimePart child) {
        return this.childs.indexOf(child);
    }

    public List getChilds() {
        return this.childs;
    }

    public MimeHeader getHeader() {
        return this.header;
    }

    public void setHeader(MimeHeader h) {
        this.header = h;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }
}

