/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.parser;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.columba.ristretto.io.Source;
import org.columba.ristretto.message.Header;
import org.columba.ristretto.parser.ParserException;

public class HeaderParser {
    private static final Pattern linePattern = Pattern.compile("([^\r\n]*)(\r?\n)|(\r\n?)");
    private static final Pattern keyValuePattern = Pattern.compile("([^:\\s]+): (.*)");
    private static final Pattern lineWrapPattern = Pattern.compile("\\s(.*)");

    private HeaderParser() {
    }

    public static Header parse(Source source) throws ParserException {
        Header header = new Header();
        Matcher lineMatcher = linePattern.matcher(source);
        Matcher keyValueMatcher = keyValuePattern.matcher("");
        Matcher lineWrapMatcher = lineWrapPattern.matcher("");
        String lastKey = null;
        String lastValue = null;
        while (lineMatcher.find()) {
            if (lineMatcher.group(1) == null) {
                if (lastValue != null) {
                    header.append(lastKey, lastValue);
                }
                return header;
            }
            if (lineMatcher.group(1).equals("")) {
                if (lastValue != null) {
                    header.append(lastKey, lastValue);
                }
                try {
                    source.seek(lineMatcher.end());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return header;
            }
            keyValueMatcher.reset(lineMatcher.group(1));
            if (keyValueMatcher.matches()) {
                if (lastValue != null) {
                    header.append(lastKey, lastValue);
                }
                lastKey = HeaderParser.normalizeKey(keyValueMatcher.group(1));
                lastValue = keyValueMatcher.group(2);
                continue;
            }
            lineWrapMatcher.reset(lineMatcher.group(1));
            if (!lineWrapMatcher.matches() || lastValue == null) continue;
            lastValue = lastValue + lineWrapMatcher.group(1);
        }
        if (lastValue != null) {
            header.append(lastKey, lastValue);
        }
        try {
            source.seek(source.length() - 1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return header;
    }

    public static String normalizeKey(String key) {
        StringBuffer normalizedKey = new StringBuffer(key.length());
        char last = key.charAt(0);
        normalizedKey.append(Character.toUpperCase(key.charAt(0)));
        for (int i = 1; i < key.length(); ++i) {
            char act = key.charAt(i);
            if (last == '-' || (last == 'I' || last == 'i') && act == 'd') {
                normalizedKey.append(Character.toUpperCase(act));
            } else {
                normalizedKey.append(Character.toLowerCase(act));
            }
            last = act;
        }
        return normalizedKey.toString();
    }
}

