/*
 * Decompiled with CFR 0.152.
 */
package org.columba.ristretto.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.columba.ristretto.ssl.DefaultTrustManager;

public class RistrettoSSLSocketFactory {
    private static RistrettoSSLSocketFactory myInstance;
    private SSLSocketFactory socketFactory;

    public static RistrettoSSLSocketFactory getInstance() {
        if (myInstance == null) {
            myInstance = new RistrettoSSLSocketFactory();
        }
        return myInstance;
    }

    protected RistrettoSSLSocketFactory() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
            this.socketFactory = sslContext.getSocketFactory();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace(System.out);
        }
        catch (KeyManagementException e) {
            e.printStackTrace(System.out);
        }
    }

    public void setTrustManager(TrustManager tm) {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{tm}, new SecureRandom());
            this.socketFactory = sslContext.getSocketFactory();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace(System.out);
        }
        catch (KeyManagementException e) {
            e.printStackTrace(System.out);
        }
    }

    public void setKeyManager(KeyManager km) {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(new KeyManager[]{km}, null, new SecureRandom());
            this.socketFactory = sslContext.getSocketFactory();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace(System.out);
        }
        catch (KeyManagementException e) {
            e.printStackTrace(System.out);
        }
    }

    public Socket createSocket(InetAddress address, int port) throws IOException {
        return this.socketFactory.createSocket(address, port);
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.socketFactory.createSocket(address, port, localAddress, localPort);
    }

    public Socket createSocket(String host, int port) throws IOException {
        return this.socketFactory.createSocket(host, port);
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.socketFactory.createSocket(host, port, localHost, localPort);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.socketFactory.createSocket(socket, host, port, autoClose);
    }
}

