/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.lattice.util;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.FileImageOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.fileupload.FileUploadException;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.User;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ImageUtils {
    public static final String KEY = ImageUtils.class.getName();
    public static final Logger log = Logger.getLogger(KEY);
    protected Connection conn;
    protected Statement s;

    public static String getRedirect(String temp) throws IOException {
        String base = Config.getProperty("BasePath");
        String redirectFile = temp.substring(base.length());
        return Config.getProperty("BaseUrl") + "/" + redirectFile;
    }

    public void close() throws SQLException {
        this.s.close();
        this.conn.close();
    }

    public File getImageData(File file, String fileName) throws FileNotFoundException, IOException, IllegalArgumentException, MraldException {
        ImageReader imagereader = ImageUtils.getImageReader(file);
        if (imagereader == null) {
            log.info("No image reader found for this file format.");
            throw new MraldException("No image reader found for this file format.");
        }
        BufferedImage image = null;
        int noImages = imagereader.getNumImages(true);
        int offset = 0;
        File rawFile = new File(fileName);
        FileImageOutputStream outFile = new FileImageOutputStream(rawFile);
        for (int i = 0; i < noImages; ++i) {
            image = imagereader.read(i);
            ImageUtils.writeOut(image, outFile, offset);
            if (image != null) continue;
            log.info("The image could not be written out.");
            throw new MraldException("The image could not be written out.");
        }
        outFile.close();
        return rawFile;
    }

    private static boolean writeOut(BufferedImage image, FileImageOutputStream outFile, int offSet) throws FileNotFoundException, IOException {
        DataBuffer dataBuffer = image.getRaster().getDataBuffer();
        if (dataBuffer.getDataType() == 0) {
            byte[] data = ((DataBufferByte)dataBuffer).getData();
            int len = data.length;
            outFile.write(data, 0, len);
        } else if (dataBuffer.getDataType() == 1) {
            short[] data = ((DataBufferUShort)dataBuffer).getData();
            int len = data.length;
            outFile.writeShorts(data, 0, len);
        }
        outFile.flush();
        return true;
    }

    protected static ImageReader getImageReader(File file) throws FileNotFoundException, IOException {
        FileImageInputStream fileimageinputstream = new FileImageInputStream(file);
        Object obj = fileimageinputstream;
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(obj);
        if (!iterator.hasNext() && !(iterator = ImageIO.getImageReaders(obj = file)).hasNext()) {
            obj = fileimageinputstream;
            String[] as = file.getName().split("\\.");
            if (as.length > 1) {
                iterator = ImageIO.getImageReadersBySuffix(as[as.length - 1]);
            }
            if (!iterator.hasNext()) {
                return null;
            }
        }
        ImageReader imagereader = iterator.next();
        imagereader.setInput(obj);
        return imagereader;
    }

    public Node createDom(String xmlFile) throws IOException {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(xmlFile));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            InputSource datafile = new InputSource(reader);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(datafile);
            return document.getDocumentElement();
        }
        catch (SAXException sxe) {
            throw new RuntimeException("\n** SAXException error " + sxe.getMessage());
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException("\n** ParseConfiguration error " + pce.getMessage());
        }
    }

    public boolean storeImage(HttpServletRequest req, User user) throws JspException, FileUploadException, IOException, Exception {
        return true;
    }

    public void downLoadFile(HttpServletResponse res, String fileName) throws IOException, FileNotFoundException, Exception {
        int len;
        File f = new File(fileName);
        String justFileName = f.getName();
        FileInputStream in = new FileInputStream(fileName);
        GZIPOutputStream out = new GZIPOutputStream((OutputStream)res.getOutputStream());
        res.setContentType("application/text");
        res.setHeader("Content-Disposition", "attachment; filename=" + justFileName + ".gz;");
        byte[] buffer = new byte[1024];
        while ((len = ((InputStream)in).read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        out.flush();
        out.close();
        ((InputStream)in).close();
    }

    public void downLoadFile(String outFileName, String fileName) throws IOException, FileNotFoundException, Exception {
        int len;
        FileInputStream in = new FileInputStream(fileName);
        FileOutputStream out = new FileOutputStream(new File(outFileName));
        byte[] buffer = new byte[1024];
        while ((len = ((InputStream)in).read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        out.flush();
        out.close();
        ((InputStream)in).close();
    }

    protected void downLoadFileEx(String xmlFile, String imageFileName, String outputFileName) throws IOException, FileNotFoundException {
    }

    public void getData(String fileName) throws IOException {
        File file = new File(fileName);
        ImageReader imagereader = ImageUtils.getImageReader(file);
        int noImages = imagereader.getNumImages(true);
        for (int i = 0; i < noImages; ++i) {
            imagereader.read(i);
        }
    }

    public static ImageWriter getImageWriter(String imageFormat) throws IOException {
        IIORegistry iioregistry = IIORegistry.getDefaultInstance();
        Iterator<ImageWriterSpi> iterator = iioregistry.getServiceProviders(ImageWriterSpi.class, true);
        while (iterator.hasNext()) {
            ImageWriterSpi imagewriterspi = iterator.next();
            String tryFormat = imagewriterspi.getNativeImageMetadataFormatName();
            if (tryFormat == null || !imageFormat.equals(tryFormat) || tryFormat.indexOf(imageFormat) <= 0) continue;
            return imagewriterspi.createWriterInstance();
        }
        return null;
    }
}

