/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.control;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WfControllerException;
import org.mitre.mrald.control.WorkFlow;
import org.mitre.mrald.util.MraldException;

public class WfController {
    private MsgObject messageObject = new MsgObject();
    private HashMap wfObjects = new HashMap();

    public WfController() {
    }

    public WfController(MsgObject thisMessage) {
        this.messageObject = thisMessage;
    }

    public void setMsgObject(MsgObject thisMessageObject) throws WfControllerException {
        this.messageObject = thisMessageObject;
    }

    public void setWfObjects(HashMap thisWfObjects) throws WfControllerException {
        this.wfObjects = thisWfObjects;
    }

    public MsgObject getMsgObject() throws WfControllerException {
        return this.messageObject;
    }

    public HashMap getWfObjects() throws WfControllerException {
        return this.wfObjects;
    }

    public void processWorkFlow() throws MraldException {
        WorkFlow wfObject = null;
        int methodSize = 0;
        for (int i = 1; i <= this.wfObjects.size(); ++i) {
            wfObject = (WorkFlow)this.wfObjects.get(new Integer(i));
            if (wfObject == null) {
                MraldException e = new MraldException("Can't find a workflow step with an Order of " + i + ".  Chances are your workflow configuration file needs to be corrected.", this.messageObject);
                throw e;
            }
            String objectName = wfObject.getWfObject();
            if (!wfObject.hasMethods()) {
                this.callMethod(objectName);
                continue;
            }
            methodSize = wfObject.getMethodSize();
            int lastNumber = 0;
            for (int k = 1; k <= methodSize; ++k) {
                ++lastNumber;
                while (!wfObject.containsKey(lastNumber)) {
                    ++lastNumber;
                }
                String methodName = wfObject.getWfMethod(lastNumber);
                this.callMethod(objectName, methodName);
            }
        }
    }

    public void callMethod(String objectName) throws MraldException {
        AbstractStep mraldObject = (AbstractStep)WfController.createObject(objectName);
        mraldObject.execute(this.messageObject);
        mraldObject = null;
    }

    public void callMethod(String objectName, String methodName, Object[] parameters, Class[] parameterTypes) throws MraldException {
        try {
            Class mraldObject = (Class)Class.forName(objectName).newInstance();
            Method method = mraldObject.getMethod(methodName, parameterTypes);
            method.invoke((Object)mraldObject, parameters);
        }
        catch (ClassNotFoundException e) {
            throw new MraldException(e, this.messageObject);
        }
        catch (NoSuchMethodException e) {
            throw new MraldException(e, this.messageObject);
        }
        catch (IllegalAccessException e) {
            throw new MraldException(e, this.messageObject);
        }
        catch (InstantiationException e) {
            throw new MraldException(e, this.messageObject);
        }
        catch (InvocationTargetException e) {
            throw new MraldException(e, this.messageObject);
        }
    }

    public void callMethod(String objectName, String methodName) throws MraldException {
        try {
            Class mraldObject = (Class)Class.forName(objectName).newInstance();
            Method method = mraldObject.getMethod(methodName, new Class[0]);
            method.invoke((Object)mraldObject, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new MraldException(e, this.messageObject);
        }
        catch (ClassNotFoundException e) {
            throw new MraldException(e, this.messageObject);
        }
        catch (IllegalAccessException e) {
            throw new MraldException(e, this.messageObject);
        }
        catch (InstantiationException e) {
            throw new MraldException(e, this.messageObject);
        }
        catch (InvocationTargetException e) {
            throw new MraldException(e, this.messageObject);
        }
    }

    public static Object createObject(String className) throws WfControllerException {
        Object object = null;
        try {
            Class<?> classDefinition = Class.forName(className);
            object = classDefinition.newInstance();
        }
        catch (InstantiationException e) {
            WfControllerException controlException = new WfControllerException(e.getMessage());
            throw controlException;
        }
        catch (IllegalAccessException e) {
            WfControllerException controlException = new WfControllerException(e.getMessage());
            throw controlException;
        }
        catch (ClassNotFoundException e) {
            WfControllerException controlException = new WfControllerException(e.getMessage());
            throw controlException;
        }
        return object;
    }
}

