/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.graphics;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.mitre.mrald.control.AbstractStep;
import org.mitre.mrald.control.MsgObject;
import org.mitre.mrald.control.WorkflowStepException;
import org.mitre.mrald.util.Config;
import org.mitre.mrald.util.DBMetaData;
import org.mitre.mrald.util.FBUtils;
import org.mitre.mrald.util.Link;
import org.mitre.mrald.util.MetaData;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.TableMetaData;

public class DBXMLGraphWriter
extends AbstractStep {
    public static final String NODE = "node";
    public static final String EDGE = "edge";
    public static final String ATT = "att";
    public static final String ID = "id";
    public static final String LABEL = "label";
    public static final String SOURCE = "source";
    public static final String TARGET = "target";
    public static final String WEIGHT = "weight";
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final String LIST = "list";
    public static final String GRAPH = "graph";
    public static final String DIRECTED = "directed";
    public static final String PKEY = "pkey";
    public static final String FKEY = "fkey";
    public static final String TABLE = "table";
    public static final String COLUMN = "column";
    public static final String TYPE = "type";
    public static final String[] NODE_ATTR = new String[]{"id", "label", "weight"};
    public static final String[] EDGE_ATTR = new String[]{"label", "weight"};
    private String datasource;
    private static String tempDir = "";

    public DBXMLGraphWriter() {
        tempDir = Config.getProperty("BasePath") + "/";
    }

    public void execute(MsgObject msg) throws WorkflowStepException {
        try {
            String fileName = msg.getValue("fileName")[0];
            this.datasource = msg.getValue("datasource")[0];
            if (fileName == null || fileName.equals("")) {
                fileName = "temp.txt";
            }
            this.writeXML(tempDir + fileName);
            msg.getRes().sendRedirect("dbViz.jsp");
        }
        catch (MraldException s) {
            throw new WorkflowStepException(s.getMessage());
        }
        catch (IOException s) {
            throw new WorkflowStepException(s.getMessage());
        }
    }

    public void writeXML(String fileName) throws MraldException {
        try {
            DBMetaData md = MetaData.getDbMetaData(this.datasource);
            PrintWriter out = new PrintWriter(new BufferedOutputStream(new FileOutputStream(fileName)));
            out.print(this.displayTables(md));
            out.flush();
            out.close();
        }
        catch (FileNotFoundException fe) {
            throw new MraldException(fe.getMessage());
        }
    }

    private String displayTables(DBMetaData md) throws MraldException {
        StringBuffer strOut = new StringBuffer();
        strOut.append("<graph directed=\"0\">");
        ArrayList tables = (ArrayList)md.getAllTableMetaData();
        Iterator iter = tables.iterator();
        HashMap keys = DBMetaData.setLinks(md);
        while (iter.hasNext()) {
            TableMetaData table = (TableMetaData)iter.next();
            String tableName = table.getName();
            strOut.append("  <node");
            for (int i = 0; i < NODE_ATTR.length; ++i) {
                String key = NODE_ATTR[i];
                if (tableName == null) continue;
                strOut.append(" " + key + "=\"" + tableName + "\"");
            }
            strOut.append(">\n");
            strOut.append(this.displayColumns(table, keys));
            strOut.append("  </node>\n");
        }
        Set links = md.getLinkList();
        for (Link link : links) {
            strOut.append(this.displayKeyDetails(link));
        }
        strOut.append("</graph>");
        return strOut.toString();
    }

    private String displayKeyDetails(Link link) {
        StringBuffer strOut = new StringBuffer();
        strOut.append("  <edge");
        strOut.append(" source=\"" + link.getPtable() + "\"");
        strOut.append(" target=\"" + link.getFtable() + "\"");
        strOut.append("/>\n");
        return strOut.toString();
    }

    private String displayColumns(TableMetaData table, HashMap keys) throws MraldException {
        StringBuffer strOut = new StringBuffer();
        Collection<String> columns = table.getColumnNames();
        Iterator<String> iter = columns.iterator();
        int i = 0;
        int fkeyCount = 0;
        while (iter.hasNext()) {
            String columnName = iter.next();
            strOut.append("  <att");
            strOut.append(" name=\"column" + ++i + "\" value=\"" + columnName + "\"");
            strOut.append("/>\n");
            String type = FBUtils.getSqlType(table.getFieldType(columnName));
            strOut.append("  <att");
            strOut.append(" name=\"type" + i + "\" value=\"" + type + "\"");
            strOut.append("/>\n");
            boolean isFk = DBMetaData.isFkey(table.getName(), columnName, keys);
            if (!isFk) continue;
            strOut.append("  <att");
            strOut.append(" name=\"fkey" + ++fkeyCount + "\" value=\"" + columnName + "\"");
            strOut.append("/>\n");
        }
        Collection<String> pKeys = table.getPrimaryKeys();
        iter = pKeys.iterator();
        i = 0;
        while (iter.hasNext()) {
            String primaryKey = iter.next();
            strOut.append("  <att");
            strOut.append(" name=\"pkey" + ++i + "\" value=\"" + primaryKey + "\"");
            strOut.append("/>\n");
        }
        return strOut.toString();
    }
}

