/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.graphics;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.mitre.mrald.graphics.MraldPalette;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MraldColorChooser
extends JPanel
implements ChangeListener {
    protected JColorChooser tcc;
    private static HashMap<String, Color> coloringItems = new HashMap();

    public MraldColorChooser(HashMap<String, Color> coloringItems) {
        super(new BorderLayout());
        this.setColoringItems(coloringItems);
        this.tcc = new JColorChooser();
        this.tcc.getSelectionModel().addChangeListener(this);
        this.tcc.setBorder(BorderFactory.createTitledBorder("Choose Color"));
        this.add((Component)this.tcc, "Last");
        this.add((Component)this.setChooserPanel(), "Center");
    }

    public void setColoringItems(HashMap<String, Color> coloringItems) {
        MraldColorChooser.coloringItems = coloringItems;
    }

    public MraldColorChooser(Color startColor, HashMap<String, Color> coloringItems) {
        super(new BorderLayout());
        this.setColoringItems(coloringItems);
        this.tcc = new JColorChooser(startColor);
        this.tcc.getSelectionModel().addChangeListener(this);
        this.tcc.setBorder(BorderFactory.createTitledBorder("Choose Color"));
        this.add((Component)this.tcc, "Last");
        this.add((Component)this.setChooserPanel(), "Center");
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    private JPanel setChooserPanel() {
        JPanel bannerPanel = new JPanel(new BorderLayout());
        int rows = 1;
        MraldPalette panelBox = new MraldPalette(coloringItems.size(), rows, coloringItems);
        bannerPanel.add((Component)panelBox, 0);
        bannerPanel.setBorder(BorderFactory.createTitledBorder("Choose item to Change Color"));
        return bannerPanel;
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame frame = new JFrame("MRALD Color Chooser");
        MraldColorChooser newContentPane = new MraldColorChooser(coloringItems);
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MraldColorChooser.createAndShowGUI();
            }
        });
    }
}

