/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.graphics;

import edu.berkeley.guir.prefuse.Display;
import edu.berkeley.guir.prefuse.ItemRegistry;
import edu.berkeley.guir.prefuse.NodeItem;
import edu.berkeley.guir.prefuse.action.AbstractAction;
import edu.berkeley.guir.prefuse.action.Action;
import edu.berkeley.guir.prefuse.action.RepaintAction;
import edu.berkeley.guir.prefuse.action.animate.ColorAnimator;
import edu.berkeley.guir.prefuse.action.animate.LocationAnimator;
import edu.berkeley.guir.prefuse.action.assignment.Layout;
import edu.berkeley.guir.prefuse.action.filter.GraphFilter;
import edu.berkeley.guir.prefuse.action.filter.TreeFilter;
import edu.berkeley.guir.prefuse.action.filter.WindowedTreeFilter;
import edu.berkeley.guir.prefuse.activity.ActionList;
import edu.berkeley.guir.prefuse.activity.Activity;
import edu.berkeley.guir.prefuse.activity.ActivityManager;
import edu.berkeley.guir.prefuse.activity.Pacer;
import edu.berkeley.guir.prefuse.activity.SlowInSlowOutPacer;
import edu.berkeley.guir.prefuse.event.ControlListener;
import edu.berkeley.guir.prefuse.graph.Graph;
import edu.berkeley.guir.prefuse.render.DefaultRendererFactory;
import edu.berkeley.guir.prefuse.render.Renderer;
import edu.berkeley.guir.prefuse.render.RendererFactory;
import edu.berkeley.guir.prefuse.render.TextItemRenderer;
import edu.berkeley.guir.prefusex.controls.AnchorUpdateControl;
import edu.berkeley.guir.prefusex.controls.DragControl;
import edu.berkeley.guir.prefusex.controls.FocusControl;
import edu.berkeley.guir.prefusex.controls.NeighborHighlightControl;
import edu.berkeley.guir.prefusex.controls.PanControl;
import edu.berkeley.guir.prefusex.controls.SubtreeDragControl;
import edu.berkeley.guir.prefusex.controls.ZoomControl;
import edu.berkeley.guir.prefusex.distortion.FisheyeDistortion;
import edu.berkeley.guir.prefusex.force.DragForce;
import edu.berkeley.guir.prefusex.force.Force;
import edu.berkeley.guir.prefusex.force.ForceSimulator;
import edu.berkeley.guir.prefusex.force.NBodyForce;
import edu.berkeley.guir.prefusex.force.SpringForce;
import edu.berkeley.guir.prefusex.layout.BalloonTreeLayout;
import edu.berkeley.guir.prefusex.layout.ForceDirectedLayout;
import edu.berkeley.guir.prefusex.layout.FruchtermanReingoldLayout;
import edu.berkeley.guir.prefusex.layout.RadialTreeLayout;
import edu.berkeley.guir.prefusex.layout.VerticalTreeLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedInputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.JApplet;
import org.mitre.mrald.graphics.DBGraphReader;
import org.mitre.mrald.graphics.MraldEdgeRenderer;
import org.mitre.mrald.graphics.MraldPanel;
import org.mitre.mrald.graphics.VisualColorFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MraldVizApplet
extends JApplet {
    protected ActionList forces;

    @Override
    public void init() {
        String inputFile = this.getParameter("fileName");
        Graph g = null;
        try {
            URL inputUrl = MraldVizApplet.class.getResource("/" + inputFile);
            g = new DBGraphReader().loadGraph(inputUrl);
            URL url = this.getCodeBase();
            URL baseUrl = new URL(this.getParameter("baseURL"));
            ItemRegistry registry = new ItemRegistry(g);
            Display display = new Display(registry);
            display.setSize(500, 500);
            display.pan(250.0, 250.0);
            VisualColorFunction colorFunc = new VisualColorFunction();
            Color panelColor = colorFunc.getColor("Background");
            display.setBackground(panelColor);
            registry.setRendererFactory((RendererFactory)this.initRenderers("label"));
            ActionList filter = new ActionList(registry);
            String propsFile = "settings.props";
            Properties settings = this.loadProperties(propsFile);
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("BoxColor", new Color(216, 210, 195));
            attributes.put("PanelColor", new Color(243, 242, 235));
            attributes.put("URL", url);
            attributes.put("SpringCoefficient", "Contract/Expand");
            attributes.put("registry", registry);
            attributes.put("display", display);
            attributes.put("colorSet", (Object)colorFunc);
            attributes.put("settings", settings);
            attributes.put("baseURL", baseUrl);
            this.forces = new ActionList(registry, -1L, 20L);
            PanControl pc = new PanControl(false);
            ZoomControl zc = new ZoomControl(false);
            String displayType = this.getParameter("displayType");
            if (displayType != null) {
                if (displayType.equals("Vertical")) {
                    this.createVerticalGraph(display, filter, zc, pc);
                } else if (displayType.equals("Radial")) {
                    this.createRadialGraph(display, filter, zc, pc);
                } else if (displayType.equals("Jung")) {
                    this.createJungGraph(display, filter);
                } else if (displayType.equals("Balloon")) {
                    this.createBalloonGraph(display, filter, registry);
                } else if (displayType.equals("Distort")) {
                    this.createDistortGraph(display, filter);
                } else if (displayType.equals("Force")) {
                    this.createForceGraph(display, filter, attributes, registry);
                }
            } else {
                this.createForceGraph(display, filter, attributes, registry);
            }
            this.forces.add((Action)colorFunc);
            attributes.put("forces", this.forces);
            MraldPanel fpanel = new MraldPanel(attributes);
            Container c = this.getContentPane();
            c.setLayout(new BorderLayout());
            c.add((Component)fpanel, "South");
            display.addControlListener((ControlListener)new NeighborHighlightControl());
            display.addControlListener((ControlListener)new DragControl(false, true));
            display.addControlListener((ControlListener)pc);
            display.addControlListener((ControlListener)zc);
            this.getContentPane().add((Component)display);
            filter.runNow();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void start() {
        this.forces.runNow();
    }

    protected void createVerticalGraph(Display display, ActionList filter, ZoomControl zc, PanControl pc) {
        display.addMouseListener((MouseListener)pc);
        display.addMouseMotionListener((MouseMotionListener)pc);
        display.addMouseListener((MouseListener)zc);
        display.addMouseMotionListener((MouseMotionListener)zc);
        filter.add((Action)new TreeFilter());
        this.forces.add((Action)new VerticalTreeLayout());
        this.forces.add((Action)new RepaintAction());
    }

    protected void createRadialGraph(Display display, ActionList filter, ZoomControl zc, PanControl pc) {
        display.addMouseListener((MouseListener)pc);
        display.addMouseMotionListener((MouseMotionListener)pc);
        display.addMouseListener((MouseListener)zc);
        display.addMouseMotionListener((MouseMotionListener)zc);
        filter.add((Action)new TreeFilter());
        this.forces.add((Action)new RadialTreeLayout());
        this.forces.add((Action)new RepaintAction());
    }

    protected void createDistortGraph(Display display, ActionList filter) {
        filter.add((Action)new TreeFilter());
        FisheyeDistortion feye = new FisheyeDistortion();
        this.forces.add((Action)new RadialTreeLayout());
        this.forces.add((Action)feye);
        this.forces.add((Action)new RepaintAction());
        AnchorUpdateControl auc = new AnchorUpdateControl((Layout)feye, (Activity)this.forces);
        display.addMouseListener((MouseListener)auc);
        display.addMouseMotionListener((MouseMotionListener)auc);
    }

    protected void createJungGraph(Display display, ActionList filter) {
        filter.add((Action)new TreeFilter());
        FruchtermanReingoldLayout test = new FruchtermanReingoldLayout();
        this.forces.add((Action)test);
    }

    protected void createForceGraph(Display display, ActionList filter, HashMap<String, Object> attributes, ItemRegistry registry) {
        ForceSimulator fsim = new ForceSimulator();
        ArrayList<String> displayForces = new ArrayList<String>();
        displayForces.add("SpringForce");
        displayForces.add("SpringCoefficient");
        attributes.put("displayForces", displayForces);
        fsim.addForce((Force)new NBodyForce(-0.4f, -1.0f, 0.9f));
        fsim.addForce((Force)new SpringForce(4.0E-8f, 75.0f));
        fsim.addForce((Force)new DragForce(-0.005f));
        filter.add((Action)new GraphFilter());
        this.forces.add((Action)new ForceDirectedLayout(fsim, false, false));
        attributes.put("fsim", fsim);
        this.forces.add((Action)new RepaintAction());
    }

    protected void createBalloonGraph(Display display, ActionList filter, ItemRegistry registry) {
        filter.add((Action)new WindowedTreeFilter(-4, true));
        filter.add((Action)new BalloonTreeLayout());
        ActionList update = new ActionList(registry);
        update.add((Action)new RepaintAction());
        ActionList animate = new ActionList(registry, 1500L, 20L);
        animate.setPacingFunction((Pacer)new SlowInSlowOutPacer());
        animate.add((Action)new LocationAnimator());
        animate.add((Action)new ColorAnimator());
        animate.add((Action)new RepaintAction());
        animate.alwaysRunAfter((Activity)filter);
        display.addControlListener((ControlListener)new FocusControl((Activity)filter));
        display.addControlListener((ControlListener)new SubtreeDragControl());
        display.addControlListener((ControlListener)new NeighborHighlightControl((Activity)update));
    }

    @Override
    public void stop() {
        this.forces.cancel();
        ActivityManager.kill();
    }

    public Properties loadProperties(String propsFile) {
        try {
            Properties settings = new Properties();
            URL propsUrl = new URL(this.getCodeBase() + "/" + propsFile);
            if (propsUrl == null) {
                return settings;
            }
            URLConnection conn = propsUrl.openConnection();
            BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
            if (in != null) {
                if (propsFile.indexOf("xml") > 0) {
                    return settings;
                }
                settings.load(in);
                return settings;
            }
            System.out.println("Setting Props File: Input  null : Could not load Settings");
            return settings;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public boolean saveProperties(String propsFile) {
        try {
            URL propsUrl = new URL(this.getCodeBase() + "/" + propsFile);
            return propsUrl != null;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private DefaultRendererFactory initRenderers(String textField) {
        try {
            TextItemRenderer nodeRenderer = new TextItemRenderer();
            nodeRenderer.setRenderType(2);
            nodeRenderer.setRoundedCorner(8, 8);
            nodeRenderer.setTextAttributeName(textField);
            MraldEdgeRenderer edgeRenderer = new MraldEdgeRenderer();
            edgeRenderer.setWeightType(0);
            edgeRenderer.setEdgeType(0);
            return new DefaultRendererFactory((Renderer)nodeRenderer, (Renderer)edgeRenderer, null);
        }
        catch (Exception e) {
            System.out.println("Exception : INit Renderers: " + e.getMessage());
            return null;
        }
    }

    public class TreeMapSizeFunction
    extends AbstractAction {
        public void run(ItemRegistry registry, double frac) {
            int leafCount = 0;
            Iterator iter = registry.getNodeItems();
            while (iter.hasNext()) {
                NodeItem n = (NodeItem)iter.next();
                if (n.getChildCount() != 0) continue;
                n.setSize(1.0);
                for (NodeItem p = (NodeItem)n.getParent(); p != null; p = (NodeItem)p.getParent()) {
                    p.setSize(1.0 + p.getSize());
                }
                ++leafCount;
            }
            Dimension d = registry.getDisplay(0).getSize();
            double area = d.width * d.height;
            double divisor = (double)leafCount / area;
            iter = registry.getNodeItems();
            while (iter.hasNext()) {
                NodeItem n = (NodeItem)iter.next();
                n.setSize(n.getSize() / divisor);
            }
            System.out.println("leafCount = " + leafCount);
        }
    }
}

