/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.graphics;

import edu.berkeley.guir.prefuse.EdgeItem;
import edu.berkeley.guir.prefuse.NodeItem;
import edu.berkeley.guir.prefuse.VisualItem;
import edu.berkeley.guir.prefuse.action.assignment.ColorFunction;
import java.awt.Color;
import java.awt.Paint;
import java.util.HashMap;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualColorFunction
extends ColorFunction {
    private Color lightGreen = new Color(237, 244, 235);
    private Color paleYellow = new Color(253, 234, 207);
    private Color darkishGreen = new Color(147, 189, 134);
    private Color paleCream = new Color(243, 242, 235);
    private Color transparent = new Color(243, 242, 235, 0);
    private String HIGHLIGHT = "HighLight";
    private String STANDARD = "Standard";
    private String FOCUS = "Focus";
    private String BACKGROUND = "Background";
    private Color highlightColor = this.paleYellow;
    private Color standardColor = this.lightGreen;
    private Color focusColor = this.darkishGreen;
    private Color backgroundColor = this.paleCream;

    public Paint getColor(VisualItem item) {
        if (item instanceof EdgeItem) {
            if (item.isHighlighted()) {
                return this.highlightColor;
            }
            return Color.LIGHT_GRAY;
        }
        return Color.BLACK;
    }

    public Color getColor(String type) {
        if (type.equals(this.HIGHLIGHT)) {
            return this.highlightColor;
        }
        if (type.equals(this.STANDARD)) {
            return this.standardColor;
        }
        if (type.equals(this.FOCUS)) {
            return this.focusColor;
        }
        return this.backgroundColor;
    }

    public Paint getFillColor(VisualItem item) {
        if (item instanceof NodeItem) {
            if (item.isHighlighted()) {
                return this.highlightColor;
            }
            if (item.isFixed()) {
                return this.focusColor;
            }
            return this.standardColor;
        }
        if (item instanceof EdgeItem) {
            return this.transparent;
        }
        return this.focusColor;
    }

    public boolean hasType(String type) {
        return type.equals(this.HIGHLIGHT) || type.equals(this.STANDARD) || type.equals(this.FOCUS) || type.equals(this.BACKGROUND);
    }

    public void setColor(String type, Color setColor) {
        if (type.equals(this.HIGHLIGHT)) {
            this.highlightColor = setColor;
        } else if (type.equals(this.FOCUS)) {
            this.focusColor = setColor;
        } else if (type.equals(this.BACKGROUND)) {
            this.backgroundColor = setColor;
        } else {
            this.standardColor = setColor;
        }
    }

    public HashMap<String, Color> getColors() {
        HashMap<String, Color> colorSet = new HashMap<String, Color>();
        colorSet.put(this.HIGHLIGHT, this.highlightColor);
        colorSet.put(this.STANDARD, this.standardColor);
        colorSet.put(this.FOCUS, this.focusColor);
        colorSet.put(this.BACKGROUND, this.backgroundColor);
        return colorSet;
    }

    public Properties saveColors(Properties props) {
        props.setProperty(this.HIGHLIGHT + "_color", new Integer(this.highlightColor.getRGB()).toString());
        props.setProperty(this.STANDARD + "_color", new Integer(this.standardColor.getRGB()).toString());
        props.setProperty(this.FOCUS + "_color", new Integer(this.focusColor.getRGB()).toString());
        props.setProperty(this.BACKGROUND + "_color", new Integer(this.backgroundColor.getRGB()).toString());
        return props;
    }

    public void loadColors(Properties props) {
        int colorInt = Integer.parseInt(props.get(this.HIGHLIGHT + "_color").toString());
        this.highlightColor = new Color(colorInt);
        colorInt = Integer.parseInt(props.get(this.STANDARD + "_color").toString());
        this.standardColor = new Color(colorInt);
        colorInt = Integer.parseInt(props.get(this.FOCUS + "_color").toString());
        this.focusColor = new Color(colorInt);
        if (props.get(this.BACKGROUND + "_color") == null) {
            colorInt = this.backgroundColor.getRGB();
            this.backgroundColor = new Color(colorInt);
        } else {
            colorInt = Integer.parseInt(props.get(this.BACKGROUND + "_color").toString());
            this.backgroundColor = new Color(colorInt);
        }
    }
}

