/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.util;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.mitre.mrald.util.LatticeFactory;
import org.mitre.mrald.util.MiscUtils;
import org.mitre.mrald.util.MraldError;
import org.mitre.mrald.util.MraldException;
import org.mitre.mrald.util.MraldOutFile;

public class Config {
    public static final String EMPTY_STR = "";
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final String FILE_SEPARATOR = "/";
    public static final String PROPS_FILE = "config.properties";
    public static final String STANDARD_PROPS_FILE = "standard.properties";
    protected static String finalPropertiesLocation;
    public static final boolean usingSecurity = true;
    public static final boolean usingValidation = false;
    private static final Properties config;
    private static PropertyChangeSupport pcs;
    private static LatticeFactory latticeFactory;

    public static void setFinalPropertiesLocation(String _finalPropertiesLocation) {
        finalPropertiesLocation = _finalPropertiesLocation;
    }

    public static void setLatticeFactory(LatticeFactory thisLatticeFactory) {
        latticeFactory = thisLatticeFactory;
    }

    public static boolean useLattice() {
        return Config.getLatticeFactory().getUsingLatticeSecurityModel();
    }

    public static LatticeFactory getLatticeFactory() {
        if (latticeFactory == null) {
            throw new NullPointerException("LatticeFactory is null.  You need to initialize this latticeFactory before attempting to use it.  This should be done in a servlet that is set to run early in the web  server startup.");
        }
        return latticeFactory;
    }

    public static void setProperty(String key, String value) {
        config.setProperty(key, value);
    }

    public static String getFinalPropertiesLocation() {
        return finalPropertiesLocation;
    }

    public static String getProperty(String key, String defaultValue) {
        if (finalPropertiesLocation == null) {
            Config.init();
        }
        String temp = config.getProperty(key, defaultValue);
        String base_path = config.getProperty("BasePath");
        String base_url = config.getProperty("BaseUrl");
        temp = MiscUtils.replace(temp, "\\[PATH\\]", base_path);
        if ((temp = MiscUtils.replace(temp, "\\[BASE_URL\\]", base_url)).endsWith(".xml")) {
            temp = "file://" + MiscUtils.replace(temp, "^\\w:", EMPTY_STR);
        }
        return temp;
    }

    public static String getProperty(String key) {
        String temp;
        if (finalPropertiesLocation == null) {
            Config.init();
        }
        if ((temp = config.getProperty(key)) == null) {
            throw new NullPointerException("Property " + key + " was not found in config.");
        }
        return Config.replacements(temp);
    }

    public static String replacements(String in) {
        String base_path = config.getProperty("BasePath");
        String base_url = config.getProperty("BaseUrl");
        in = MiscUtils.replace(in, "[PATH]", base_path);
        if ((in = MiscUtils.replace(in, "[BASE_URL]", base_url)).endsWith(".xml")) {
            int colon = in.indexOf(58);
            if (colon != -1) {
                in = in.substring(colon + 1);
            }
            in = "file://" + in;
        }
        return in;
    }

    public static void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    public static void fireChangeEvent() {
        pcs.firePropertyChange("reloaded props", 0, 1);
    }

    public static void init(String propertiesFileLocation) {
        finalPropertiesLocation = propertiesFileLocation;
        Config.init();
    }

    public static void init() {
        if (finalPropertiesLocation == null) {
            finalPropertiesLocation = System.getProperty("testProps");
            if (finalPropertiesLocation == null) {
                throw new NullPointerException("Can't initialize config.  Can't find a config.properties file.  Try specifying one explicitly by using init(String) or setting it using the setFinalPropertiesLocation(String) method");
            }
            try {
                FileInputStream in = new FileInputStream(finalPropertiesLocation);
                config.load(in);
                ((InputStream)in).close();
                Config.fireChangeEvent();
                Config.updateProxy();
                return;
            }
            catch (FileNotFoundException e) {
                throw new MraldError("Could find the partition configuration file at " + finalPropertiesLocation, e);
            }
            catch (IOException e) {
                throw new MraldError("IO Error reading from " + finalPropertiesLocation, e);
            }
        }
        String toRead = EMPTY_STR;
        try {
            toRead = finalPropertiesLocation + PROPS_FILE;
            FileInputStream in = new FileInputStream(toRead);
            config.load(in);
            ((InputStream)in).close();
            try {
                toRead = finalPropertiesLocation + STANDARD_PROPS_FILE;
                in = new FileInputStream(toRead);
                config.load(in);
                ((InputStream)in).close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            Config.fireChangeEvent();
            Config.updateProxy();
        }
        catch (FileNotFoundException e) {
            throw new MraldError("Could find the configuration file at " + toRead, e);
        }
        catch (IOException e) {
            throw new MraldError("IO Error reading from " + toRead, e);
        }
    }

    public static void updateProxy() {
        try {
            if (config.getProperty("ProxyHost") != null && !config.getProperty("ProxyHost").equals(EMPTY_STR)) {
                System.getProperties().put("http.proxyHost", config.getProperty("ProxyHost"));
                System.getProperties().put("http.proxyPort", config.getProperty("ProxyPort"));
            } else {
                System.getProperties().remove("http.proxyHost");
                System.getProperties().remove("http.proxyPort");
            }
        }
        catch (Exception e) {
            MraldOutFile.logToFile(new MraldException("Likely a security exception - you must allow modification to system properties if you want to use the proxy", e));
        }
    }

    public static String toString(boolean dummy) {
        return config.toString().replace(',', '\n');
    }

    static {
        config = new Properties();
        pcs = new PropertyChangeSupport(config);
    }
}

