/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.mrald.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashMultiValueMap<K, V>
implements Map<K, V> {
    private final HashMap<K, Set<V>> map;

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    public HashMultiValueMap() {
        this.map = new HashMap();
    }

    public HashMultiValueMap(int size) {
        this.map = new HashMap(size);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Set<V> values : this.map.values()) {
            if (!values.contains(value)) continue;
            return true;
        }
        return false;
    }

    public Set<V> getAll(K key) {
        return this.map.get(key);
    }

    @Override
    public V get(Object key) {
        Set<V> values = this.getAll(key);
        return values == null ? null : (V)values.iterator().next();
    }

    @Override
    public V put(K key, V value) {
        Set<V> values = this.getAll(key);
        if (values == null) {
            values = new LinkedHashSet<V>();
            this.map.put(key, values);
        }
        values.add(value);
        return value;
    }

    @Override
    public V remove(Object key) {
        Set<V> values = this.map.remove(key);
        return values == null ? null : (V)values.iterator().next();
    }

    public V remove(Object key, V value) {
        boolean found;
        Set<V> values = this.getAll(key);
        boolean bl = found = values == null ? false : values.remove(value);
        if (values.isEmpty()) {
            this.map.remove(key);
        }
        return (V)(found ? value : null);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public Collection<V> values() {
        return new ValueList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryPair
    implements Map.Entry {
        public final K key;
        public V value;
        private final Set<V> values;

        public EntryPair(K key, V value, Set<V> values) {
            this.key = key;
            this.value = value;
            this.values = values;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) throws ClassCastException {
            this.values.remove(value);
            this.values.add(value);
            return value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueList
    extends AbstractCollection<V> {
        private final EntrySet values;

        private ValueList() {
            this.values = new EntrySet();
        }

        @Override
        public Iterator<V> iterator() {
            return new EntrySet.EntryIterator(this.values){
                {
                    EntrySet entrySet = x0;
                    entrySet.getClass();
                }

                @Override
                public V next() {
                    this.moveNext();
                    return this.current.value;
                }
            };
        }

        @Override
        public int size() {
            return this.values.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private final ArrayList<EntryPair> entries = new ArrayList();

        public EntrySet() {
            for (Object key : HashMultiValueMap.this.keySet()) {
                Set values = HashMultiValueMap.this.getAll(key);
                for (Object value : values) {
                    this.entries.add(new EntryPair(key, value, values));
                }
            }
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(){

                @Override
                public EntryPair next() {
                    this.moveNext();
                    return this.current;
                }
            };
        }

        @Override
        public int size() {
            return this.entries.size();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private abstract class EntryIterator<E>
        implements Iterator<E> {
            protected Iterator<EntryPair> itr;
            protected EntryPair current;

            private EntryIterator() {
                this.itr = EntrySet.this.entries.iterator();
                this.current = null;
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public abstract E next();

            protected void moveNext() {
                this.current = this.itr.next();
            }

            @Override
            public void remove() {
                this.itr.remove();
                HashMultiValueMap.this.remove(this.current.key, this.current.value);
            }
        }
    }
}

